"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolRegistryResolver = useToolRegistryResolver;
var _react = require("react");
var _tools_form_registry = require("../../components/tools/form/registry/tools_form_registry");
var _use_onechat_service = require("../use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useToolRegistryResolver(toolType) {
  const services = (0, _use_onechat_service.useOnechatServices)();
  return (0, _react.useCallback)(async (data, context, options) => {
    const toolTypeConfig = (0, _tools_form_registry.getToolTypeConfig)(toolType);
    if (!toolTypeConfig) throw new Error(`Unknown tool type: ${toolType}`);
    const {
      getValidationResolver
    } = toolTypeConfig;
    // @ts-expect-error TS2345 - Union type ToolFormData cannot be narrowed to specific resolver type at compile time
    return getValidationResolver(services)(data, context, options);
  }, [toolType, services]);
}