"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlParamRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _onechatCommon = require("@kbn/onechat-common");
var _react2 = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_esql_params_validation = require("../../hooks/use_esql_params_validation");
var _i18n = require("../../i18n");
var _tool_form_types = require("../../types/tool_form_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/esql/esql_param_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIELD_TYPE_TOKEN_MAP = {
  [_onechatCommon.EsqlToolFieldType.TEXT]: 'tokenString',
  [_onechatCommon.EsqlToolFieldType.KEYWORD]: 'tokenKeyword',
  [_onechatCommon.EsqlToolFieldType.LONG]: 'tokenNumber',
  [_onechatCommon.EsqlToolFieldType.INTEGER]: 'tokenNumber',
  [_onechatCommon.EsqlToolFieldType.DOUBLE]: 'tokenNumber',
  [_onechatCommon.EsqlToolFieldType.FLOAT]: 'tokenNumber',
  [_onechatCommon.EsqlToolFieldType.BOOLEAN]: 'tokenBoolean',
  [_onechatCommon.EsqlToolFieldType.DATE]: 'tokenDate',
  [_onechatCommon.EsqlToolFieldType.OBJECT]: 'tokenObject',
  [_onechatCommon.EsqlToolFieldType.NESTED]: 'tokenNested'
};
const EsqlParamRow = ({
  index,
  paramField,
  removeParamField
}) => {
  var _errors$params;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const {
    control,
    formState,
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const {
    errors,
    isSubmitted
  } = formState;
  const {
    triggerEsqlParamWarnings,
    triggerEsqlParamFieldsValidation
  } = (0, _use_esql_params_validation.useEsqlParamsValidation)();
  const handleValidation = (0, _react2.useCallback)(() => {
    triggerEsqlParamFieldsValidation(['name']);
    triggerEsqlParamWarnings();
  }, [triggerEsqlParamFieldsValidation, triggerEsqlParamWarnings]);
  const [warning, source] = (0, _reactHookForm.useWatch)({
    control,
    name: [`params.${index}.warning`, `params.${index}.source`]
  });
  const paramErrors = (_errors$params = errors.params) === null || _errors$params === void 0 ? void 0 : _errors$params[index];
  const errorMessages = (0, _react2.useMemo)(() => {
    // Mobile will display field level validation errors
    if (isMobile) return '';
    return [paramErrors === null || paramErrors === void 0 ? void 0 : paramErrors.name, paramErrors === null || paramErrors === void 0 ? void 0 : paramErrors.description, paramErrors === null || paramErrors === void 0 ? void 0 : paramErrors.type].filter(error => !!error).map(error => error.message).join('\n');
  }, [paramErrors === null || paramErrors === void 0 ? void 0 : paramErrors.name, paramErrors === null || paramErrors === void 0 ? void 0 : paramErrors.description, paramErrors === null || paramErrors === void 0 ? void 0 : paramErrors.type, isMobile]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRow, {
    key: paramField.id,
    css: (0, _react.css)`
        &:hover {
          background-color: inherit; /* Disable row hover effect */
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRowCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, !isMobile && (errorMessages && /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    content: errorMessages,
    type: "errorFilled",
    color: euiTheme.colors.danger,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }) || warning && /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    content: warning,
    type: "warningFilled",
    color: euiTheme.colors.warning,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }) || (source === _tool_form_types.EsqlParamSource.Inferred ? /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "sparkles",
    color: "subdued",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "documentEdit",
    color: "subdued",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRowCell, {
    textOnly: false,
    mobileOptions: {
      header: _i18n.i18nMessages.paramNameLabel,
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: `params.${index}.name`,
    render: ({
      field: {
        ref,
        onChange,
        onBlur,
        ...field
      },
      fieldState: {
        invalid,
        error
      }
    }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      compressed: true,
      fullWidth: true,
      placeholder: _i18n.i18nMessages.paramNamePlaceholder,
      inputRef: ref,
      isInvalid: invalid,
      onBlur: handleValidation,
      onChange: event => {
        onChange(event);
        if (source === _tool_form_types.EsqlParamSource.Inferred) {
          setValue(`params.${index}.source`, _tool_form_types.EsqlParamSource.Custom);
        }
        if (isSubmitted) {
          handleValidation();
        }
      }
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 15
      }
    })), isMobile && (invalid && error !== null && error !== void 0 && error.message ? /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 19
      }
    }, error.message) : warning && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 21
      }
    }, warning))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRowCell, {
    textOnly: false,
    mobileOptions: {
      header: _i18n.i18nMessages.paramDescriptionLabel,
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: `params.${index}.description`,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState: {
        invalid,
        error
      }
    }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      compressed: true,
      fullWidth: true,
      placeholder: _i18n.i18nMessages.paramDescriptionPlaceholder,
      inputRef: ref,
      isInvalid: invalid
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 15
      }
    })), isMobile && invalid && (error === null || error === void 0 ? void 0 : error.message) && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 17
      }
    }, error.message)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRowCell, {
    textOnly: false,
    mobileOptions: {
      header: _i18n.i18nMessages.paramTypeLabel,
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: `params.${index}.type`,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState: {
        invalid,
        error
      }
    }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSuperSelect, (0, _extends2.default)({
      compressed: true,
      fullWidth: true,
      popoverProps: {
        panelMinWidth: 150,
        zIndex: euiTheme.levels.header - 1 // ensure the popover doesn't render on top of the bottom bar
      },
      options: Object.values(_onechatCommon.EsqlToolFieldType).map(option => ({
        value: option,
        inputDisplay: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "s",
          responsive: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 217,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 218,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToken, {
          iconType: FIELD_TYPE_TOKEN_MAP[option],
          css: (0, _react.css)`
                            width: ${euiTheme.size.m};
                            height: ${euiTheme.size.m};
                          `,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 219,
            columnNumber: 25
          }
        })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 227,
            columnNumber: 23
          }
        }, option))
      })),
      valueOfSelected: field.value,
      isInvalid: invalid
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 15
      }
    })), isMobile && invalid && (error === null || error === void 0 ? void 0 : error.message) && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 17
      }
    }, error.message)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRowCell, {
    align: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: `params.${index}.optional`,
    render: ({
      field: {
        ref,
        onChange,
        value,
        ...field
      }
    }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiCheckbox, (0, _extends2.default)({
      id: `params.${index}.optional`,
      inputRef: ref,
      onChange: e => {
        onChange(e.target.checked);
      },
      checked: value
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRowCell, {
    hasActions: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    onClick: () => {
      removeParamField(index);
      triggerEsqlParamFieldsValidation(['name']);
    },
    size: "s",
    "aria-label": _i18n.i18nMessages.removeParamButtonLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  })));
};
exports.EsqlParamRow = EsqlParamRow;