"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationWrapper = exports.actionsContainer = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visualizationWrapper = (euiTheme, height) => (0, _react.css)({
  position: 'relative',
  height,
  overflow: 'visible',
  '&:hover > .visualization-button-actions, &:focus-within > .visualization-button-actions': {
    opacity: 1,
    pointerEvents: 'auto'
  }
});
exports.visualizationWrapper = visualizationWrapper;
const actionsContainer = euiTheme => (0, _react.css)({
  position: 'absolute',
  top: `-${euiTheme.size.xs}`,
  right: `-${euiTheme.size.xs}`,
  zIndex: 2,
  opacity: 0,
  pointerEvents: 'none',
  transition: `opacity ${euiTheme.animation.fast} ease-in-out`,
  display: 'inline-flex',
  gap: 0
});
exports.actionsContainer = actionsContainer;