"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_conversation = require("../../hooks/use_conversation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConversationTitle = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    title,
    isLoading
  } = (0, _use_conversation.useConversationTitle)();
  const [previousTitle, setPreviousTitle] = (0, _react.useState)('');
  const [currentText, setCurrentText] = (0, _react.useState)('');
  const labels = {
    ariaLabel: _i18n.i18n.translate('xpack.onechat.conversationTitle.ariaLabel', {
      defaultMessage: 'Conversation title'
    }),
    newConversationDisplay: _i18n.i18n.translate('xpack.onechat.conversationTitle.newConversationDisplay', {
      defaultMessage: 'New conversation'
    })
  };
  (0, _react.useEffect)(() => {
    if (isLoading) return;
    const fullText = title || labels.newConversationDisplay;

    // Typewriter effect: only when transitioning from "New conversation" to actual title
    if (previousTitle === labels.newConversationDisplay && title) {
      if (currentText.length < fullText.length) {
        // start typewriter effect
        const typingSpeed = 50;
        const timeout = setTimeout(() => {
          setCurrentText(fullText.substring(0, currentText.length + 1));
        }, typingSpeed);
        return () => clearTimeout(timeout);
      }
    } else if (title && title !== previousTitle) {
      // Normal title change: set immediately without typewriter effect I.e. when changing from one conversation to another
      setCurrentText(fullText);
    }
    // always track the previous title
    setPreviousTitle(fullText);
  }, [title, currentText, labels.newConversationDisplay, isLoading, previousTitle]);
  const titleDisplayText = currentText || previousTitle;
  const sectionStyles = (0, _react2.css)`
    display: flex;
    flex-direction: row;
    gap: ${euiTheme.size.s};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    css: sectionStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, !isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "aria-label": labels.ariaLabel,
    size: "xxs",
    "data-test-subj": "agentBuilderConversationTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, titleDisplayText)));
};
exports.ConversationTitle = ConversationTitle;