"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _tools_selection = require("../tools_selection");
var _use_ui_privileges = require("../../../../hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/edit/tabs/tools_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ToolsTab = ({
  control,
  tools,
  isLoading,
  isFormDisabled
}) => {
  const {
    manageTools
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const [showActiveOnly, setShowActiveOnly] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "configuration.tools",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_tools_selection.ToolsSelection, {
      tools: tools,
      toolsLoading: isLoading,
      selectedTools: field.value,
      onToolsChange: field.onChange,
      disabled: isFormDisabled,
      showActiveOnly: showActiveOnly || !manageTools // For readonly users, show only active tools
      ,
      onShowActiveOnlyChange: setShowActiveOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }));
};
exports.ToolsTab = ToolsTab;