"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlToolFieldType = void 0;
exports.isEsqlTool = isEsqlTool;
var _definition = require("../definition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Common ES Field Types
 */
let EsqlToolFieldType = exports.EsqlToolFieldType = /*#__PURE__*/function (EsqlToolFieldType) {
  EsqlToolFieldType["TEXT"] = "text";
  EsqlToolFieldType["KEYWORD"] = "keyword";
  EsqlToolFieldType["LONG"] = "long";
  EsqlToolFieldType["INTEGER"] = "integer";
  EsqlToolFieldType["DOUBLE"] = "double";
  EsqlToolFieldType["FLOAT"] = "float";
  EsqlToolFieldType["BOOLEAN"] = "boolean";
  EsqlToolFieldType["DATE"] = "date";
  EsqlToolFieldType["OBJECT"] = "object";
  EsqlToolFieldType["NESTED"] = "nested";
  return EsqlToolFieldType;
}({}); // To make compatible with ToolDefinition['configuration']
// eslint-disable-next-line @typescript-eslint/consistent-type-definitions
function isEsqlTool(tool) {
  return tool.type === _definition.ToolType.esql;
}