"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsResourceType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Represents the type of a "searchable" resource in the cluster.
 * Searchable resources are indices, aliases and data streams
 */
let EsResourceType = exports.EsResourceType = /*#__PURE__*/function (EsResourceType) {
  EsResourceType["index"] = "index";
  EsResourceType["alias"] = "alias";
  EsResourceType["dataStream"] = "data_stream";
  return EsResourceType;
}({});