"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.protectedNamespaces = exports.isInProtectedNamespace = exports.internalNamespaces = exports.hasNamespaceName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * List of internally used namespaces
 * Note: those are not necessarily all protected.
 */
const internalNamespaces = exports.internalNamespaces = {
  platformCore: 'platform.core'
};

/**
 * List of protected namespaces which can only be used by internal tools.
 */
const protectedNamespaces = exports.protectedNamespaces = [internalNamespaces.platformCore];

/**
 * Checks if the provided tool name belongs to a protected namespace.
 */
const isInProtectedNamespace = toolName => {
  for (const namespace of protectedNamespaces) {
    if (toolName.startsWith(`${namespace}.`)) {
      return true;
    }
  }
  return false;
};

/**
 * Checks if the provided name is an internal or protected namespace.
 */
exports.isInProtectedNamespace = isInProtectedNamespace;
const hasNamespaceName = toolName => {
  return protectedNamespaces.includes(toolName) || Object.values(internalNamespaces).includes(toolName);
};
exports.hasNamespaceName = hasNamespaceName;