"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/cases-plugin/common");
var _common2 = require("@kbn/discover-plugin/common");
var _logs_feature = require("./features/logs_feature");
var _common3 = require("../common");
var _alerts = require("../common/locators/alerts");
var _bootstrap_annotations = require("./lib/annotations/bootstrap_annotations");
var _register_rule_types = require("./lib/rules/register_rule_types");
var _get_global_observability_server_route_repository = require("./routes/get_global_observability_server_route_repository");
var _register_routes = require("./routes/register_routes");
var _threshold = require("./saved_objects/threshold");
var _services = require("./services");
var _ui_settings = require("./ui_settings");
var _cases_v = require("./features/cases_v1");
var _cases_v2 = require("./features/cases_v2");
var _cases_v3 = require("./features/cases_v3");
var _set_esql_recommended_queries = require("./lib/esql_extensions/set_esql_recommended_queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initContext = initContext;
    this.initContext = initContext;
    this.logger = initContext.logger.get();
  }
  setup(core, plugins) {
    var _plugins$cases;
    const casesCapabilities = (0, _common.createUICapabilities)();
    const casesApiTags = (0, _common.getApiTags)(_common3.observabilityFeatureId);
    const config = this.initContext.config.get();
    const alertsLocator = plugins.share.url.locators.create(new _alerts.AlertsLocatorDefinition());
    const logsLocator = plugins.share.url.locators.get(_common2.DISCOVER_APP_LOCATOR);
    const alertDetailsContextualInsightsService = new _services.AlertDetailsContextualInsightsService();
    if ((_plugins$cases = plugins.cases) !== null && _plugins$cases !== void 0 && _plugins$cases.config.enabled) {
      plugins.features.registerKibanaFeature((0, _cases_v.getCasesFeature)(casesCapabilities, casesApiTags));
      plugins.features.registerKibanaFeature((0, _cases_v2.getCasesFeatureV2)(casesCapabilities, casesApiTags));
      plugins.features.registerKibanaFeature((0, _cases_v3.getCasesFeatureV3)(casesCapabilities, casesApiTags));
    }
    plugins.features.registerKibanaFeature((0, _logs_feature.getLogsFeature)());
    let annotationsApiPromise;
    core.uiSettings.register(_ui_settings.uiSettings);
    core.pricing.registerProductFeatures(_common3.OBSERVABILITY_TIERED_FEATURES);
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    core.savedObjects.registerType(_threshold.threshold);
    (0, _register_rule_types.registerRuleTypes)(plugins.alerting, core.http.basePath, config, this.logger, {
      alertsLocator,
      logsLocator
    });
    void core.getStartServices().then(([coreStart, pluginStart]) => {
      const isCompleteOverviewEnabled = coreStart.pricing.isFeatureAvailable('observability:complete_overview');
      if (config.annotations.enabled && isCompleteOverviewEnabled) {
        annotationsApiPromise = (0, _bootstrap_annotations.bootstrapAnnotations)({
          core,
          index: config.annotations.index,
          context: this.initContext
        }).catch(err => {
          const logger = this.initContext.logger.get('annotations');
          logger.warn(err);
          throw err;
        });
      }
      (0, _register_routes.registerRoutes)({
        core,
        dependencies: {
          pluginsSetup: {
            ...plugins,
            core
          },
          dashboard: pluginStart.dashboard,
          ruleRegistry: pluginStart.ruleRegistry,
          dataViews: pluginStart.dataViews,
          spaces: pluginStart.spaces,
          ruleDataService,
          assistant: {
            alertDetailsContextualInsightsService
          },
          getRulesClientWithRequest: pluginStart.alerting.getRulesClientWithRequest
        },
        logger: this.logger,
        repository: (0, _get_global_observability_server_route_repository.getObservabilityServerRouteRepository)(config),
        isDev: this.initContext.env.mode.dev
      });
      (0, _set_esql_recommended_queries.setEsqlRecommendedQueries)(plugins.esql);
    });
    return {
      getAlertDetailsConfig() {
        return config.unsafe.alertDetails;
      },
      getScopedAnnotationsClient: async (...args) => {
        const api = await annotationsApiPromise;
        return api === null || api === void 0 ? void 0 : api.getScopedAnnotationsClient(...args);
      },
      alertDetailsContextualInsightsService,
      alertsLocator,
      managedOtlpServiceUrl: config.managedOtlpServiceUrl
    };
  }
  start(core, plugins) {}
  stop() {}
}
exports.ObservabilityPlugin = ObservabilityPlugin;