"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesFeatureV2 = void 0;
var _server = require("@kbn/core/server");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesFeatureV2 = (casesCapabilities, casesApiTags) => ({
  deprecated: {
    notice: _i18n.i18n.translate('xpack.observability.featureRegistry.casesFeature.deprecationMessage', {
      defaultMessage: 'The {currentId} permissions are deprecated, please see {casesFeatureIdV3}.',
      values: {
        currentId: _common.casesFeatureIdV2,
        casesFeatureIdV3: _common.casesFeatureIdV3
      }
    })
  },
  id: _common.casesFeatureIdV2,
  name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkObservabilityTitle', {
    defaultMessage: 'Cases'
  }),
  order: 1100,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  app: [_common.casesFeatureId, 'kibana'],
  catalogue: [_common.observabilityFeatureId],
  cases: [_common.observabilityFeatureId],
  privileges: {
    all: {
      api: casesApiTags.all,
      app: [_common.casesFeatureId, 'kibana'],
      catalogue: [_common.observabilityFeatureId],
      cases: {
        create: [_common.observabilityFeatureId],
        read: [_common.observabilityFeatureId],
        update: [_common.observabilityFeatureId],
        push: [_common.observabilityFeatureId],
        assign: [_common.observabilityFeatureId]
      },
      savedObject: {
        all: [..._saved_objects.hiddenTypes],
        read: [..._saved_objects.hiddenTypes]
      },
      ui: [...casesCapabilities.all, ...casesCapabilities.assignCase],
      replacedBy: {
        default: [{
          feature: _common.casesFeatureIdV3,
          privileges: ['all']
        }],
        minimal: [{
          feature: _common.casesFeatureIdV3,
          privileges: ['minimal_all', 'cases_assign']
        }]
      }
    },
    read: {
      api: casesApiTags.read,
      app: [_common.casesFeatureId, 'kibana'],
      catalogue: [_common.observabilityFeatureId],
      cases: {
        read: [_common.observabilityFeatureId]
      },
      savedObject: {
        all: [],
        read: [..._saved_objects.hiddenTypes]
      },
      ui: casesCapabilities.read,
      replacedBy: {
        default: [{
          feature: _common.casesFeatureIdV3,
          privileges: ['read']
        }],
        minimal: [{
          feature: _common.casesFeatureIdV3,
          privileges: ['minimal_read']
        }]
      }
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureName', {
      defaultMessage: 'Delete'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: casesApiTags.delete,
        id: 'cases_delete',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureDetails', {
          defaultMessage: 'Delete cases and comments'
        }),
        includeIn: 'all',
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        cases: {
          delete: [_common.observabilityFeatureId]
        },
        ui: casesCapabilities.delete,
        replacedBy: [{
          feature: _common.casesFeatureIdV3,
          privileges: ['cases_delete']
        }]
      }]
    }]
  }, {
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.casesSettingsSubFeatureName', {
      defaultMessage: 'Case settings'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'cases_settings',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.casesSettingsSubFeatureDetails', {
          defaultMessage: 'Edit case settings'
        }),
        includeIn: 'all',
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        cases: {
          settings: [_common.observabilityFeatureId]
        },
        ui: casesCapabilities.settings,
        replacedBy: [{
          feature: _common.casesFeatureIdV3,
          privileges: ['cases_settings']
        }]
      }]
    }]
  }, {
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.addCommentsSubFeatureName', {
      defaultMessage: 'Create comments & attachments'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: casesApiTags.createComment,
        id: 'create_comment',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.addCommentsSubFeatureDetails', {
          defaultMessage: 'Add comments to cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        cases: {
          createComment: [_common.observabilityFeatureId]
        },
        ui: casesCapabilities.createComment,
        replacedBy: [{
          feature: _common.casesFeatureIdV3,
          privileges: ['create_comment']
        }]
      }]
    }]
  }, {
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.reopenCaseSubFeatureName', {
      defaultMessage: 'Re-open'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'case_reopen',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.reopenCaseSubFeatureDetails', {
          defaultMessage: 'Re-open closed cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [],
          read: []
        },
        cases: {
          reopenCase: [_common.observabilityFeatureId]
        },
        ui: casesCapabilities.reopenCase,
        replacedBy: [{
          feature: _common.casesFeatureIdV3,
          privileges: ['case_reopen']
        }]
      }]
    }]
  }]
});
exports.getCasesFeatureV2 = getCasesFeatureV2;