"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSelectedOptions = updateSelectedOptions;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function updateSelectedOptions(status, controlIndex, alertFilterControlHandler) {
  if (!alertFilterControlHandler || controlIndex < 0) {
    return;
  }
  if (status === _constants.ALERT_STATUS_ALL) {
    var _controlApi$clearSele;
    const controlApi = alertFilterControlHandler === null || alertFilterControlHandler === void 0 ? void 0 : alertFilterControlHandler.children$.getValue()[controlIndex];
    controlApi === null || controlApi === void 0 ? void 0 : (_controlApi$clearSele = controlApi.clearSelections) === null || _controlApi$clearSele === void 0 ? void 0 : _controlApi$clearSele.call(controlApi);
  } else {
    const controlApi = alertFilterControlHandler === null || alertFilterControlHandler === void 0 ? void 0 : alertFilterControlHandler.children$.getValue()[controlIndex];
    if (controlApi && controlApi.setSelectedOptions) {
      controlApi.setSelectedOptions([status]);
    }
  }
}