"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setStatusOnControlConfigs = setStatusOnControlConfigs;
var _constants = require("@kbn/alerts-ui-shared/src/alert_filter_controls/constants");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setStatusOnControlConfigs(status, controlConfigs) {
  const updateControlConfigs = controlConfigs ? [...controlConfigs] : _constants.DEFAULT_CONTROLS;
  const statusControl = updateControlConfigs.find(control => control.fieldName === _ruleDataUtils.ALERT_STATUS);
  if (statusControl) {
    if (status === _constants2.ALERT_STATUS_ALL) {
      statusControl.selectedOptions = [];
    } else {
      statusControl.selectedOptions = [status];
    }
  }
  return updateControlConfigs;
}