"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensFieldFormatter = exports.isRate = exports.getLensOperationFromRuleMetric = exports.getBufferThreshold = exports.LensFieldFormat = void 0;
var _types = require("../../../common/custom_threshold_rule/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLensOperationFromRuleMetric = metric => {
  const {
    aggType,
    field,
    filter = ''
  } = metric;
  let operation = aggType;
  const operationArgs = [];
  const escapedFilter = filter.replace(/\\/g, '\\\\').replace(/'/g, "\\'");
  if (aggType === _types.Aggregators.RATE) {
    return {
      operation: 'counter_rate',
      operationWithField: `counter_rate(max("${field}"), kql='${escapedFilter}')`,
      sourceField: `"${field}"` || ''
    };
  }
  if (aggType === _types.Aggregators.AVERAGE) operation = 'average';
  if (aggType === _types.Aggregators.CARDINALITY) operation = 'unique_count';
  if (aggType === _types.Aggregators.P95 || aggType === _types.Aggregators.P99) operation = 'percentile';
  if (aggType === _types.Aggregators.COUNT) operation = 'count';
  if (field) {
    operationArgs.push(`"${field}"`);
  }
  if (aggType === _types.Aggregators.P95) {
    operationArgs.push('percentile=95');
  }
  if (aggType === _types.Aggregators.P99) {
    operationArgs.push('percentile=99');
  }
  if (escapedFilter) operationArgs.push(`kql='${escapedFilter}'`);
  return {
    operation,
    operationWithField: `${operation}(${operationArgs.join(', ')})`,
    sourceField: `"${field}"` || ''
  };
};
exports.getLensOperationFromRuleMetric = getLensOperationFromRuleMetric;
const getBufferThreshold = threshold => (Math.ceil((threshold || 0) * 1.1 * 100) / 100).toFixed(2).toString();
exports.getBufferThreshold = getBufferThreshold;
const LensFieldFormat = exports.LensFieldFormat = {
  NUMBER: 'number',
  PERCENT: 'percent',
  BITS: 'bits'
};
const lensFieldFormatter = metrics => {
  if (metrics.length < 1 || !metrics[0].field) return LensFieldFormat.NUMBER;
  const firstMetricField = metrics[0].field;
  if (firstMetricField.endsWith('.pct')) return LensFieldFormat.PERCENT;
  if (firstMetricField.endsWith('.bytes')) return LensFieldFormat.BITS;
  return LensFieldFormat.NUMBER;
};
exports.lensFieldFormatter = lensFieldFormatter;
const isRate = metrics => Boolean(metrics.length > 0 && metrics[0].aggType === _types.Aggregators.RATE);
exports.isRate = isRate;