"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSourceNotifier = void 0;
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSourceNotifier = () => {
  const {
    services: {
      notifications
    }
  } = (0, _kibana_react.useKibana)();
  const updateFailure = message => {
    notifications.toasts.addDanger({
      toastLifeTimeMs: 3000,
      title: _i18n.i18n.translate('xpack.observability.customThreshold.rule.sourceConfiguration.updateFailureTitle', {
        defaultMessage: 'Configuration update failed'
      }),
      text: [_i18n.i18n.translate('xpack.observability.customThreshold.rule.sourceConfiguration.updateFailureBody', {
        defaultMessage: "We couldn't apply the changes to the Metrics configuration. Try again later."
      }), message].filter(Boolean).join(' ')
    });
  };
  const updateSuccess = () => {
    notifications.toasts.addSuccess({
      toastLifeTimeMs: 3000,
      title: _i18n.i18n.translate('xpack.observability.customThreshold.rule.sourceConfiguration.updateSuccessTitle', {
        defaultMessage: 'Metrics settings successfully updated'
      })
    });
  };
  return {
    updateFailure,
    updateSuccess
  };
};
exports.useSourceNotifier = useSourceNotifier;