"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.infraSources = exports.generateSourceLink = exports.apmSources = void 0;
var _common = require("@kbn/observability-shared-plugin/common");
var _get_apm_app_url = require("./get_apm_app_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_NAME = 'host.name';
const CONTAINER_ID = 'container.id';
const KUBERNETES_POD_ID = 'kubernetes.pod.id';
const AWS_EC2_INSTANCE = 'cloud.instance.id';
const AWS_S3_BUCKET = 'aws.s3.instance.id';
const AWS_RDS_DATABASES = 'aws.rds.instance.id';
const AWS_SQS_QUEUE = 'aws.sqs.instance.id';
const METRICS_DETAILS_PATH = '/app/metrics/detail';
const infraSources = exports.infraSources = [HOST_NAME, CONTAINER_ID, KUBERNETES_POD_ID, AWS_EC2_INSTANCE, AWS_S3_BUCKET, AWS_RDS_DATABASES, AWS_SQS_QUEUE];
const apmSources = exports.apmSources = [_common.SERVICE_NAME, _common.SERVICE_ENVIRONMENT, _common.TRANSACTION_TYPE, _common.TRANSACTION_NAME];
const infraSourceLinks = {
  [HOST_NAME]: `${METRICS_DETAILS_PATH}/host`,
  [CONTAINER_ID]: `${METRICS_DETAILS_PATH}/container`,
  [KUBERNETES_POD_ID]: `${METRICS_DETAILS_PATH}/pod`,
  [AWS_EC2_INSTANCE]: `${METRICS_DETAILS_PATH}/awsEC2`,
  [AWS_S3_BUCKET]: `${METRICS_DETAILS_PATH}/awsS3`,
  [AWS_RDS_DATABASES]: `${METRICS_DETAILS_PATH}/awsRDS`,
  [AWS_SQS_QUEUE]: `${METRICS_DETAILS_PATH}/awsSQS`
};
const generateInfraSourceLink = ({
  field,
  value
}, hostTimeRange, infraTimeRange) => {
  const link = field === HOST_NAME ? `${infraSourceLinks[field]}/${value}?${hostTimeRange}` : `${infraSourceLinks[field]}/${value}?${infraTimeRange}`;
  return link;
};
const generateApmSourceLink = ({
  field,
  value
}, timeRange, serviceName, baseLocator) => {
  if (!serviceName) {
    return undefined;
  }
  let apmLocatorPayload = {
    serviceName,
    environment: 'ENVIRONMENT_ALL',
    rangeFrom: timeRange.from,
    rangeTo: timeRange.to
  };
  if (field === _common.TRANSACTION_NAME) {
    apmLocatorPayload = {
      ...apmLocatorPayload,
      serviceOverviewTab: 'transactions',
      transactionName: value
    };
  } else if (field === _common.TRANSACTION_TYPE) {
    apmLocatorPayload = {
      ...apmLocatorPayload,
      transactionType: value
    };
  } else if (field === _common.SERVICE_ENVIRONMENT) {
    apmLocatorPayload = {
      ...apmLocatorPayload,
      environment: value
    };
  }
  const apmAppLocator = (0, _get_apm_app_url.getApmAppLocator)(baseLocator);
  return apmAppLocator === null || apmAppLocator === void 0 ? void 0 : apmAppLocator.getRedirectUrl(apmLocatorPayload);
};
const generateSourceLink = ({
  field,
  value
}, timeRange, prepend, serviceName, baseLocator) => {
  if (infraSources.includes(field)) {
    const hostTimeRange = `assetDetails=(dateRange:(from:'${timeRange.from}',to:'${timeRange.to}'))`;
    const infraTimeRange = `_a=(time:(from:'${timeRange.from}',to:'${timeRange.to}',interval:>=1m))`;
    return prepend === null || prepend === void 0 ? void 0 : prepend(generateInfraSourceLink({
      field,
      value
    }, hostTimeRange, infraTimeRange));
  } else if (apmSources.includes(field)) {
    return generateApmSourceLink({
      field,
      value
    }, timeRange, serviceName, baseLocator);
  }
};
exports.generateSourceLink = generateSourceLink;