"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesOverviewLocatorDefinition = exports.CaseDetailsLocatorDefinition = exports.CASE_DETAIL_PATH = void 0;
var _common = require("@kbn/spaces-plugin/common");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASE_DETAIL_PATH = exports.CASE_DETAIL_PATH = '/app/observability/cases';
const CaseDetailsLocatorDefinition = () => ({
  id: _.casesDetailLocatorID,
  getLocation: async params => {
    const {
      spaceId,
      basePath,
      caseId
    } = params;
    const path = (spaceId ? (0, _common.addSpaceIdToPath)(basePath !== null && basePath !== void 0 ? basePath : '', spaceId, CASE_DETAIL_PATH) : (basePath !== null && basePath !== void 0 ? basePath : '') + CASE_DETAIL_PATH).concat('/', caseId);
    return {
      app: 'observability',
      path,
      state: {}
    };
  }
});
exports.CaseDetailsLocatorDefinition = CaseDetailsLocatorDefinition;
const CasesOverviewLocatorDefinition = () => ({
  id: _.casesOverviewLocatorID,
  getLocation: async params => {
    const {
      spaceId,
      basePath
    } = params;
    const path = spaceId ? (0, _common.addSpaceIdToPath)(basePath !== null && basePath !== void 0 ? basePath : '', spaceId, CASE_DETAIL_PATH) : (basePath !== null && basePath !== void 0 ? basePath : '') + CASE_DETAIL_PATH;
    return {
      app: 'observability',
      path,
      state: {}
    };
  }
});
exports.CasesOverviewLocatorDefinition = CasesOverviewLocatorDefinition;