"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.otelApmOnboardingRouteRepository = void 0;
var _uuid = require("uuid");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _create_managed_otlp_service_api_key = require("../../lib/api_key/create_managed_otlp_service_api_key");
var _has_log_monitoring_privileges = require("../../lib/api_key/has_log_monitoring_privileges");
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
var _get_managed_otlp_service_url = require("../../lib/get_managed_otlp_service_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createOtelApmOnboardingFlowRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'POST /internal/observability_onboarding/otel_apm/flow',
  security: {
    authz: {
      enabled: false,
      reason: 'Authorization is checked by custom logic using Elasticsearch client'
    }
  },
  async handler(resources) {
    const {
      context,
      plugins
    } = resources;
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const hasPrivileges = await (0, _has_log_monitoring_privileges.hasLogMonitoringPrivileges)(client.asCurrentUser, true);
    if (!hasPrivileges) {
      throw _boom.default.forbidden("You don't have enough privileges to start a new onboarding flow. Contact your system administrator to grant you the required privileges.");
    }
    const {
      encoded: apiKeyEncoded
    } = await (0, _create_managed_otlp_service_api_key.createManagedOtlpServiceApiKey)(client.asCurrentUser, 'ingest-otel-apm');
    return {
      onboardingId: (0, _uuid.v4)(),
      apiKeyEncoded,
      managedOtlpServiceUrl: (0, _get_managed_otlp_service_url.getManagedOtlpServiceUrl)(plugins)
    };
  }
});
const otelApmOnboardingRouteRepository = exports.otelApmOnboardingRouteRepository = {
  ...createOtelApmOnboardingFlowRoute
};