"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFallbackESUrl = getFallbackESUrl;
exports.getFallbackKibanaUrl = getFallbackKibanaUrl;
exports.getKibanaUrl = getKibanaUrl;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getKibanaUrl(coreSetup, cloudSetup) {
  var _ref, _coreSetup$http$baseP;
  return (// falls back to local network binding
    // then cloud id
    (_ref = (_coreSetup$http$baseP = coreSetup.http.basePath.publicBaseUrl) !== null && _coreSetup$http$baseP !== void 0 ? _coreSetup$http$baseP : // priority given to server.publicBaseUrl
    cloudSetup === null || cloudSetup === void 0 ? void 0 : cloudSetup.kibanaUrl) !== null && _ref !== void 0 ? _ref : getFallbackKibanaUrl(coreSetup)
  );
}
function getFallbackKibanaUrl({
  http
}) {
  const basePath = http.basePath;
  const {
    protocol,
    hostname,
    port
  } = http.getServerInfo();
  return `${protocol}://${hostname}:${port}${basePath
  // Prepending on '' removes the serverBasePath
  .prepend('/').slice(0, -1)}`;
}
async function getFallbackESUrl(esLegacyConfigService) {
  const config = await esLegacyConfigService.readConfig();
  return config.hosts;
}