"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _common = require("../common");
var _locator_definition = require("./locators/onboarding_locator/locator_definition");
var _telemetry_events = require("../common/telemetry_events");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ObservabilityOnboardingPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "locators", void 0);
    this.ctx = ctx;
  }
  setup(core, plugins) {
    const stackVersion = this.ctx.env.packageInfo.version;
    const config = this.ctx.config.get();
    const isServerlessBuild = this.ctx.env.packageInfo.buildFlavor === 'serverless';
    const isDevEnvironment = this.ctx.env.mode.dev;
    const pluginSetupDeps = plugins;
    core.application.register({
      id: _common.PLUGIN_ID,
      title: 'Observability Onboarding',
      order: 8500,
      euiIconType: 'logoObservability',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: ['add data'],
      async mount(appMountParameters) {
        var _pluginSetupDeps$clou, _pluginSetupDeps$clou2, _pluginSetupDeps$clou3;
        // Load application bundle and Get start service
        const [{
          renderApp
        }, [coreStart, corePlugins]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application/app'))), core.getStartServices()]);
        const {
          createCallApi
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/create_call_api')));
        createCallApi(core);
        return renderApp({
          core: coreStart,
          deps: pluginSetupDeps,
          appMountParameters,
          corePlugins: corePlugins,
          config,
          context: {
            isDev: isDevEnvironment,
            isCloud: Boolean((_pluginSetupDeps$clou = pluginSetupDeps.cloud) === null || _pluginSetupDeps$clou === void 0 ? void 0 : _pluginSetupDeps$clou.isCloudEnabled),
            isServerless: Boolean((_pluginSetupDeps$clou2 = pluginSetupDeps.cloud) === null || _pluginSetupDeps$clou2 === void 0 ? void 0 : _pluginSetupDeps$clou2.isServerlessEnabled) || isServerlessBuild,
            stackVersion,
            cloudServiceProvider: (_pluginSetupDeps$clou3 = pluginSetupDeps.cloud) === null || _pluginSetupDeps$clou3 === void 0 ? void 0 : _pluginSetupDeps$clou3.csp
          }
        });
      },
      visibleIn: ['globalSearch']
    });
    this.locators = {
      onboarding: plugins.share.url.locators.create(new _locator_definition.ObservabilityOnboardingLocatorDefinition())
    };
    core.analytics.registerEventType(_telemetry_events.OBSERVABILITY_ONBOARDING_TELEMETRY_EVENT);
    core.analytics.registerEventType(_telemetry_events.OBSERVABILITY_ONBOARDING_FEEDBACK_TELEMETRY_EVENT);
    core.analytics.registerEventType(_telemetry_events.OBSERVABILITY_ONBOARDING_FLOW_PROGRESS_TELEMETRY_EVENT);
    core.analytics.registerEventType(_telemetry_events.OBSERVABILITY_ONBOARDING_FLOW_ERROR_TELEMETRY_EVENT);
    core.analytics.registerEventType(_telemetry_events.OBSERVABILITY_ONBOARDING_FLOW_DATASET_DETECTED_TELEMETRY_EVENT);
    return {
      locators: this.locators,
      getLocator: () => {
        var _this$locators;
        return (_this$locators = this.locators) === null || _this$locators === void 0 ? void 0 : _this$locators.onboarding;
      }
    };
  }
  start(_core, _plugins) {
    return {
      locators: this.locators
    };
  }
}
exports.ObservabilityOnboardingPlugin = ObservabilityOnboardingPlugin;