"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticAgentSetupCommand = getElasticAgentSetupCommand;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getElasticAgentSetupCommand({
  elasticAgentPlatform,
  apiKeyEncoded = '$API_KEY',
  apiEndpoint = '$API_ENDPOINT',
  scriptDownloadUrl = '$SCRIPT_DOWNLOAD_URL',
  elasticAgentVersion = '$ELASTIC_AGENT_VERSION',
  autoDownloadConfig = false,
  onboardingId = '$ONBOARDING_ID'
}) {
  const setupScriptFilename = 'standalone_agent_setup.sh';
  const LINUX_MACOS_COMMAND = oneLine`
      curl ${scriptDownloadUrl} -o ${setupScriptFilename} &&
      sudo bash ${setupScriptFilename} ${apiKeyEncoded} ${apiEndpoint} ${elasticAgentVersion} ${onboardingId} ${autoDownloadConfig ? `autoDownloadConfig=1` : ''}
    `;
  const PLATFORM_COMMAND = {
    'linux-tar': LINUX_MACOS_COMMAND,
    macos: LINUX_MACOS_COMMAND,
    windows: oneLine`
      curl -O https://elastic.co/agent-setup.sh &&
      sudo bash agent-setup.sh -- service.name=my-service --url=https://elasticsearch:8220 --enrollment-token=SRSc2ozWUItWXNuWE5oZzdERFU6anJtY0FIzhSRGlzeTJYcUF5UklfUQ==
    `
  };
  return PLATFORM_COMMAND[elasticAgentPlatform];
}
function oneLine(parts, ...args) {
  const str = (0, _lodash.flatten)((0, _lodash.zip)(parts, args)).join('');
  return str.replace(/\s+/g, ' ').trim();
}