"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatItemControls = ChatItemControls;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _feedback_buttons = require("../buttons/feedback_buttons");
var _stop_generating_button = require("../buttons/stop_generating_button");
var _regenerate_response_button = require("../buttons/regenerate_response_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/components/chat/chat_item_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const containerClassName = (0, _css.css)`
  padding-top: 4px;
  padding-bottom: 4px;
`;
function ChatItemControls({
  error,
  loading,
  canRegenerate,
  canGiveFeedback,
  onFeedbackClick,
  onRegenerateClick,
  onStopGeneratingClick
}) {
  const displayFeedback = !error && canGiveFeedback;
  const displayRegenerate = !loading && canRegenerate;
  let controls;
  if (loading) {
    controls = /*#__PURE__*/_react.default.createElement(_stop_generating_button.StopGeneratingButton, {
      onClick: onStopGeneratingClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 16
      }
    });
  } else if (displayFeedback || displayRegenerate) {
    controls = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    }, displayFeedback ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
      onClickFeedback: onFeedbackClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 13
      }
    })) : null, displayRegenerate ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_regenerate_response_button.RegenerateResponseButton, {
      onClick: onRegenerateClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    })) : null);
  } else {
    controls = null;
  }
  return controls ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s",
    className: containerClassName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, controls)) : null;
}