"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = SettingsPage;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _aiAssistant = require("@kbn/ai-assistant");
var _use_app_context = require("../../hooks/use_app_context");
var _settings_tab = require("./settings_tab/settings_tab");
var _knowledge_base_tab = require("./knowledge_base_tab");
var _use_kibana = require("../../hooks/use_kibana");
var _search_connector_tab = require("./search_connector_tab");
var _get_solution_specific_logos = require("../../helpers/get_solution_specific_logos");
var _get_solution_specific_labels = require("../../helpers/get_solution_specific_labels");
var _use_observability_management_params = require("../../hooks/use_observability_management_params");
var _use_observability_management_router = require("../../hooks/use_observability_management_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/settings_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SettingsPage() {
  var _capabilities$actions, _capabilities$actions2, _capabilities$actions3, _capabilities$actions4, _knowledgeBase$status, _tabs$find;
  const {
    setBreadcrumbs
  } = (0, _use_app_context.useAppContext)();
  const {
    services: {
      application: {
        navigateToApp,
        isAppRegistered,
        capabilities
      },
      serverless,
      spaces,
      cloud
    }
  } = (0, _use_kibana.useKibana)();
  const router = (0, _use_observability_management_router.useObservabilityAIAssistantManagementRouter)();
  const knowledgeBase = (0, _aiAssistant.useKnowledgeBase)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const headerIconShadow = (0, _eui.useEuiShadow)('s');
  const [currentSpaceSolution, setCurrentSpaceSolution] = (0, _react.useState)();

  // Determine the current solution.
  let currentSolution;
  if (serverless) {
    var _cloud$serverless;
    const projectType = cloud === null || cloud === void 0 ? void 0 : (_cloud$serverless = cloud.serverless) === null || _cloud$serverless === void 0 ? void 0 : _cloud$serverless.projectType;
    currentSolution = projectType === 'observability' ? 'oblt' : 'es';
  } else {
    currentSolution = currentSpaceSolution;
  }
  const hasConnectorsAllPrivilege = ((_capabilities$actions = capabilities.actions) === null || _capabilities$actions === void 0 ? void 0 : _capabilities$actions.show) === true && ((_capabilities$actions2 = capabilities.actions) === null || _capabilities$actions2 === void 0 ? void 0 : _capabilities$actions2.execute) === true && ((_capabilities$actions3 = capabilities.actions) === null || _capabilities$actions3 === void 0 ? void 0 : _capabilities$actions3.delete) === true && ((_capabilities$actions4 = capabilities.actions) === null || _capabilities$actions4 === void 0 ? void 0 : _capabilities$actions4.save) === true;
  const {
    query: {
      tab
    }
  } = (0, _use_observability_management_params.useObservabilityAIAssistantManagementRouterParams)('/');
  (0, _react.useEffect)(() => {
    const getCurrentSpace = async () => {
      if (spaces) {
        const space = await spaces.getActiveSpace();
        setCurrentSpaceSolution(space === null || space === void 0 ? void 0 : space.solution);
      }
    };
    getCurrentSpace();
  }, [spaces]);
  const {
    breadcrumbText,
    title
  } = (0, _get_solution_specific_labels.getSolutionSpecificLabels)({
    solution: currentSolution,
    isServerless: !!serverless
  });
  const logos = (0, _get_solution_specific_logos.getSolutionSpecificLogos)(currentSolution);
  (0, _react.useEffect)(() => {
    if (serverless) {
      serverless.setBreadcrumbs([{
        text: breadcrumbText
      }]);
    } else {
      setBreadcrumbs([{
        text: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.breadcrumb.index', {
          defaultMessage: 'AI Assistants'
        }),
        onClick: e => {
          e.preventDefault();
          navigateToApp('management', {
            path: '/ai/aiAssistantManagementSelection'
          });
        }
      }, {
        text: breadcrumbText
      }]);
    }
  }, [breadcrumbText, navigateToApp, serverless, setBreadcrumbs]);
  const tabs = [{
    id: 'settings',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.settingsLabel', {
      defaultMessage: 'Settings'
    }),
    content: /*#__PURE__*/_react.default.createElement(_settings_tab.SettingsTab, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 16
      }
    })
  }, {
    id: 'knowledge_base',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.knowledgeBaseLabel', {
      defaultMessage: 'Knowledge Base'
    }),
    content: /*#__PURE__*/_react.default.createElement(_knowledge_base_tab.KnowledgeBaseTab, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 16
      }
    }),
    disabled: !((_knowledgeBase$status = knowledgeBase.status.value) !== null && _knowledgeBase$status !== void 0 && _knowledgeBase$status.enabled)
  }, {
    id: 'search_connector',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.searchConnector', {
      defaultMessage: 'Search Connectors'
    }),
    content: /*#__PURE__*/_react.default.createElement(_search_connector_tab.SearchConnectorTab, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 16
      }
    }),
    disabled: !isAppRegistered('enterpriseSearch')
  }];
  const selectedTabId = tabs.some(t => t.id === tab) ? tab : tabs[0].id;
  const selectedTabContent = (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  const onSelectedTabChanged = id => {
    router.push('/', {
      path: '/',
      query: {
        tab: id
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "aiAssistantSettingsPage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false,
    direction: "row",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, logos.map(logo => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: logo,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: logo,
    style: {
      backgroundColor: euiTheme.colors.backgroundBasePlain,
      borderRadius: '50%',
      padding: 6
    },
    css: (0, _react2.css)`
                  ${headerIconShadow};
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, title)))), hasConnectorsAllPrivilege ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "gear",
    size: "m",
    onClick: () => navigateToApp('management', {
      path: 'ai/genAiSettings'
    }),
    "data-test-subj": "genAiSettingsButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.genAiSettingsButton', {
    defaultMessage: 'GenAI Settings'
  }))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "settingsPageTabs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, tabs.filter(t => !t.disabled).map((t, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: index,
    "data-test-subj": `settingsPageTab-${t.id}`,
    onClick: () => onSelectedTabChanged(t.id),
    isSelected: t.id === selectedTabId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, t.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }), selectedTabContent, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }));
}