"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditableSettings = useEditableSettings;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _managementSettingsFieldDefinition = require("@kbn/management-settings-field-definition");
var _managementSettingsUtilities = require("@kbn/management-settings-utilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSettingsFields({
  settingsKeys,
  uiSettings
}) {
  if (!uiSettings) {
    return {};
  }
  const uiSettingsDefinition = uiSettings.getAll();
  const normalizedSettings = (0, _managementSettingsUtilities.normalizeSettings)(uiSettingsDefinition);
  const fields = {};
  settingsKeys.forEach(key => {
    const setting = normalizedSettings[key];
    if (setting) {
      const field = (0, _managementSettingsFieldDefinition.getFieldDefinition)({
        id: key,
        setting,
        params: {
          isCustom: uiSettings.isCustom(key),
          isOverridden: uiSettings.isOverridden(key)
        }
      });
      fields[key] = field;
    }
  });
  return fields;
}
function useEditableSettings(settingsKeys) {
  const {
    services: {
      settings
    }
  } = (0, _public.useKibana)();
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [forceReloadSettings, setForceReloadSettings] = (0, _react.useState)(0);
  const [unsavedChanges, setUnsavedChanges] = _react.default.useState({});
  const fields = (0, _react.useMemo)(() => {
    return getSettingsFields({
      settingsKeys,
      uiSettings: settings === null || settings === void 0 ? void 0 : settings.client
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [settings, settingsKeys, forceReloadSettings]);
  const handleFieldChange = (id, change) => {
    if (!change) {
      const {
        [id]: unsavedChange,
        ...rest
      } = unsavedChanges;
      setUnsavedChanges(rest);
      return;
    }
    setUnsavedChanges(changes => ({
      ...changes,
      [id]: change
    }));
  };
  function cleanUnsavedChanges() {
    setUnsavedChanges({});
  }
  async function saveAll() {
    if (settings && !(0, _lodash.isEmpty)(unsavedChanges)) {
      let updateErrorOccurred = false;
      const subscription = settings.client.getUpdateErrors$().subscribe(error => {
        updateErrorOccurred = true;
      });
      try {
        setIsSaving(true);
        const arr = Object.entries(unsavedChanges).map(([key, value]) => settings.client.set(key, value.unsavedValue));
        await Promise.all(arr);
        setForceReloadSettings(state => ++state);
        cleanUnsavedChanges();
        if (updateErrorOccurred) {
          throw new Error('One or more settings updates failed');
        }
      } catch (e) {
        throw e;
      } finally {
        setIsSaving(false);
        if (subscription) {
          subscription.unsubscribe();
        }
      }
    }
  }
  async function saveSingleSetting(id, change) {
    if (settings) {
      try {
        setIsSaving(true);
        await settings.client.set(id, change);
        setForceReloadSettings(state => ++state);
      } finally {
        setIsSaving(false);
      }
    }
  }
  return {
    fields,
    unsavedChanges,
    handleFieldChange,
    saveAll,
    isSaving,
    cleanUnsavedChanges,
    saveSingleSetting
  };
}