"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizeESQLFunction = void 0;
var _common = require("@kbn/observability-ai-assistant-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visualizeESQLFunction = exports.visualizeESQLFunction = {
  name: _common.VISUALIZE_QUERY_FUNCTION_NAME,
  isInternal: true,
  description: 'Use this function to visualize charts for ES|QL queries.',
  descriptionForUser: 'Use this function to visualize charts for ES|QL queries.',
  parameters: {
    type: 'object',
    properties: {
      query: {
        type: 'string'
      },
      intention: {
        type: 'string',
        enum: _common.VISUALIZE_ESQL_USER_INTENTIONS
      }
    },
    required: ['query', 'intention']
  },
  contexts: ['core']
};