"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeStatement = makeStatement;
var _plugin_statement = require("./plugin_statement");
var _if_statement = require("./if_statement");
var _queue = require("./queue");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function makeStatement(pipelineGraphVertex, pipelineStage) {
  switch (pipelineGraphVertex.typeString) {
    case 'plugin':
      return _plugin_statement.PluginStatement.fromPipelineGraphVertex(pipelineGraphVertex, pipelineStage);
    case 'if':
      return _if_statement.IfStatement.fromPipelineGraphVertex(pipelineGraphVertex, pipelineStage);
    case 'queue':
      return _queue.Queue.fromPipelineGraphVertex(pipelineGraphVertex, pipelineStage);
    default:
      throw new Error(`Unknown vertex class: ${pipelineGraphVertex.typeString}`);
  }
}