"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IfStatement = void 0;
var _statement = require("./statement");
var _make_statement = require("./make_statement");
var _utils = require("./utils");
var _if_element = require("../list/if_element");
var _else_element = require("../list/else_element");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function makeStatementsForOutgoingVertices(outgoingVertices, statements, next, pipelineStage) {
  outgoingVertices.forEach(vertex => {
    let currentVertex = vertex;
    while ((0, _utils.isVertexPipelineStage)(currentVertex, pipelineStage) && currentVertex !== next) {
      statements.push((0, _make_statement.makeStatement)(currentVertex, pipelineStage));
      currentVertex = currentVertex.next;
    }
  });
}
function addStatementsToList(list, statements, depth, id) {
  statements.forEach(statement => {
    list.push(...statement.toList(depth, id));
  });
}
class IfStatement extends _statement.Statement {
  constructor(vertex, trueStatements, elseStatements) {
    super(vertex);
    const {
      name
    } = vertex;
    this.condition = name;
    this.trueStatements = trueStatements;
    this.elseStatements = elseStatements;
  }
  toList(depth, parentId) {
    const list = [];
    const ifElement = new _if_element.IfElement(this, depth, parentId);
    list.push(ifElement);
    const nestedElementDepth = depth + 1;
    addStatementsToList(list, this.trueStatements, nestedElementDepth, ifElement.id);
    if (this.elseStatements.length) {
      const elseElement = new _else_element.ElseElement(this, depth, parentId);
      list.push(elseElement);
      addStatementsToList(list, this.elseStatements, nestedElementDepth, elseElement.id);
    }
    return list;
  }
  static fromPipelineGraphVertex(ifVertex, pipelineStage) {
    const trueStatements = [];
    const elseStatements = [];
    const {
      trueOutgoingVertices,
      falseOutgoingVertices
    } = ifVertex;
    const next = ifVertex.next;
    makeStatementsForOutgoingVertices(trueOutgoingVertices, trueStatements, next, pipelineStage);
    makeStatementsForOutgoingVertices(falseOutgoingVertices, elseStatements, next, pipelineStage);
    return new IfStatement(ifVertex, trueStatements, elseStatements);
  }
}
exports.IfStatement = IfStatement;