"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Shard = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _calculate_class = require("../lib/calculate_class");
var _vents = require("../lib/vents");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/shard_allocation/components/shard.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const shardStyle = theme => (0, _react2.css)`
  ${(0, _eui.logicalCSS)('padding', `${theme.euiTheme.size.xs} ${theme.euiTheme.size.s}`)}
  align-self: center;
  font-size: ${(0, _eui.euiFontSize)(theme, 'xs').fontSize};
  position: relative;
  display: inline-block;
`;
function getColor(classes) {
  const classList = classes.split(' ');
  if (classList.includes('emergency')) {
    return 'danger';
  }
  if (classList.includes('unassigned')) {
    if (classList.includes('replica')) {
      return 'warning';
    }
    return 'danger';
  }
  if (classList.includes('relocating')) {
    return 'accent';
  }
  if (classList.includes('initializing')) {
    return 'default';
  }
  if (classList.includes('primary')) {
    return 'primary';
  }
  if (classList.includes('replica')) {
    return 'success';
  }
}
class Shard extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      tooltipVisible: false
    });
    (0, _defineProperty2.default)(this, "generateKey", relocating => {
      const shard = this.props.shard;
      const shardType = (0, _lodash.get)(shard, 'shard.primary', shard.primary) ? 'primary' : 'replica';
      const additionId = (0, _lodash.get)(shard, 'shard.state', shard.state) === 'UNASSIGNED' ? Math.random() : '';
      const node = relocating ? (0, _lodash.get)(shard, 'relocation_node.uuid', shard.relocating_node) : (0, _lodash.get)(shard, 'shard.name', shard.node);
      return shard.index + '.' + node + '.' + shardType + '.' + shard.shard + additionId;
    });
    (0, _defineProperty2.default)(this, "toggle", event => {
      if (this.props.shard.tooltip_message) {
        const action = event.type === 'mouseenter' ? 'show' : 'hide';
        const key = this.generateKey(true);
        this.setState({
          tooltipVisible: action === 'show'
        });
        _vents.vents.trigger(key, action);
      }
    });
  }
  componentDidMount() {
    let key;
    const shard = this.props.shard;
    const self = this;
    if (shard.tooltip_message) {
      key = this.generateKey();
      _vents.vents.on(key, function (action) {
        self.setState({
          tooltipVisible: action === 'show'
        });
      });
    }
  }
  componentWillUnmount() {
    let key;
    const shard = this.props.shard;
    if (shard.tooltip_message) {
      key = this.generateKey();
      _vents.vents.clear(key);
    }
  }
  render() {
    const shard = this.props.shard;
    const classes = (0, _calculate_class.calculateClass)(shard);
    const color = getColor(classes);
    const classification = classes + ' ' + (0, _lodash.get)(shard, 'shard.number', shard.shard);
    let shardUi = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 19
      }
    }, (0, _lodash.get)(shard, 'shard.number', shard.shard));
    const tooltipContent = shard.tooltip_message || _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.shardDisplayName', {
      defaultMessage: 'Shard'
    });
    if (this.state.tooltipVisible) {
      shardUi = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: tooltipContent,
        position: "bottom",
        "data-test-subj": "shardTooltip",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 11
        }
      }, shardUi));
    }

    // data attrs for automated testing verification
    return /*#__PURE__*/_react.default.createElement("div", {
      onMouseEnter: this.toggle,
      onMouseLeave: this.toggle,
      css: shard.type === 'shard' && shardStyle,
      className: classes,
      "data-shard-tooltip": tooltipContent,
      "data-shard-classification": classification,
      "data-test-subj": "shardIcon",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, shardUi);
  }
}
exports.Shard = Shard;
(0, _defineProperty2.default)(Shard, "displayName", _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.shardDisplayName', {
  defaultMessage: 'Shard'
}));