"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Stats = Stats;
var _react = _interopRequireDefault(require("react"));
var _format_number = require("../../lib/format_number");
var _summary_status = require("../summary_status");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/beats/stats.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Stats({
  stats,
  alerts
}) {
  const {
    total,
    types,
    stats: {
      bytesSent,
      totalEvents
    }
  } = stats;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.beats.overview.totalBeatsLabel', {
      defaultMessage: 'Total Beats'
    }),
    value: (0, _format_number.formatMetric)(total, 'int_commas'),
    'data-test-subj': 'totalBeats'
  }];
  metrics.push(...types.map(({
    type,
    count
  }) => ({
    label: type,
    value: (0, _format_number.formatMetric)(count, 'int_commas'),
    'data-test-subj': 'typeCount',
    'data-test-type-count': `${type}:${count}`
  })));
  metrics.push({
    label: _i18n.i18n.translate('xpack.monitoring.beats.overview.totalEventsLabel', {
      defaultMessage: 'Total Events'
    }),
    value: (0, _format_number.formatMetric)(totalEvents, '0.[0]a'),
    'data-test-subj': 'totalEvents'
  });
  metrics.push({
    label: _i18n.i18n.translate('xpack.monitoring.beats.overview.bytesSentLabel', {
      defaultMessage: 'Bytes Sent'
    }),
    value: (0, _format_number.formatMetric)(bytesSent, 'byte'),
    'data-test-subj': 'bytesSent'
  });
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    alerts: alerts,
    "data-test-subj": "beatsSummaryStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 10
    }
  });
}