"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchIndicesPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _elasticsearch_template = require("./elasticsearch_template");
var _global_state_context = require("../../contexts/global_state_context");
var _elasticsearch = require("../../../components/elasticsearch");
var _setup_mode = require("../../../components/renderers/setup_mode");
var _setup_mode_context = require("../../../components/setup_mode/setup_mode_context");
var _use_table = require("../../hooks/use_table");
var _use_local_storage = require("../../hooks/use_local_storage");
var _fetch_alerts = require("../../../lib/fetch_alerts");
var _constants = require("../../../../common/constants");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/elasticsearch/indices_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ElasticsearchIndicesPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    getPaginationTableProps
  } = (0, _use_table.useTable)('elasticsearch.indices');
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const [data, setData] = (0, _react.useState)({});
  const [showSystemIndices, setShowSystemIndices] = (0, _use_local_storage.useLocalStorage)('showSystemIndices', false);
  const [alerts, setAlerts] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inElasticsearch: true
      });
    }
  }, [cluster, generateBreadcrumbs]);
  const title = _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.routeTitle', {
    defaultMessage: 'Elasticsearch - Indices'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.pageTitle', {
    defaultMessage: 'Elasticsearch indices'
  });
  const toggleShowSystemIndices = (0, _react.useCallback)(() => setShowSystemIndices(!showSystemIndices), [showSystemIndices, setShowSystemIndices]);
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/elasticsearch/indices`;
    if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch && clusterUuid) {
      var _services$http2;
      const response = await ((_services$http2 = services.http) === null || _services$http2 === void 0 ? void 0 : _services$http2.fetch(url, {
        method: 'POST',
        query: {
          show_system_indices: showSystemIndices
        },
        body: JSON.stringify({
          ccs,
          timeRange: {
            min: bounds.min.toISOString(),
            max: bounds.max.toISOString()
          }
        })
      }));
      setData(response);
      const alertsResponse = await (0, _fetch_alerts.fetchAlerts)({
        fetch: services.http.fetch,
        clusterUuid,
        alertTypeIds: [_constants.RULE_LARGE_SHARD_SIZE],
        timeRange: {
          min: bounds.min.valueOf(),
          max: bounds.max.valueOf()
        }
      });
      setAlerts(alertsResponse);
    }
  }, [(_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http, clusterUuid, showSystemIndices, ccs]);
  return /*#__PURE__*/_react.default.createElement(_elasticsearch_template.ElasticsearchTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    "data-test-subj": "elasticsearchOverviewPage",
    cluster: cluster,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "elasticsearchIndicesListingPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_setup_mode.SetupModeRenderer, {
    productName: _constants.ELASTICSEARCH_SYSTEM_ID,
    render: ({
      flyoutComponent,
      bottomBarComponent
    }) => /*#__PURE__*/_react.default.createElement(_setup_mode_context.SetupModeContext.Provider, {
      value: {
        setupModeSupported: true
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    }, flyoutComponent, /*#__PURE__*/_react.default.createElement(_elasticsearch.ElasticsearchIndices, (0, _extends2.default)({
      clusterStatus: data.clusterStatus,
      indices: data.indices,
      alerts: alerts,
      showSystemIndices: showSystemIndices,
      toggleShowSystemIndices: toggleShowSystemIndices
    }, getPaginationTableProps(), {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 15
      }
    })), bottomBarComponent),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })));
};
exports.ElasticsearchIndicesPage = ElasticsearchIndicesPage;