"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleWorkerProxyService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _monaco_imports = require("../../monaco_imports");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * This class contains logic to create a web worker where the code for the Console parser can
 * execute without blocking the main thread. The parser only runs when the Monaco editor
 * is used with the Console language. The parser can only be accessed via this proxy service class.
 */
class ConsoleWorkerProxyService {
  constructor() {
    (0, _defineProperty2.default)(this, "worker", void 0);
  }
  async getParserResult(modelUri) {
    if (!this.worker) {
      throw new Error('Worker Proxy Service has not been setup!');
    }
    await this.worker.withSyncedResources([modelUri]);
    const parser = await this.worker.getProxy();
    return parser.getParserResult(modelUri.toString());
  }
  setup() {
    this.worker = _monaco_imports.monaco.editor.createWebWorker({
      label: _constants.CONSOLE_LANG_ID,
      moduleId: ''
    });
  }
  stop() {
    if (this.worker) this.worker.dispose();
  }
}
exports.ConsoleWorkerProxyService = ConsoleWorkerProxyService;