"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleParsedRequestsProvider = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * This class is a helper interface that is used in the Console plugin.
 * The provider access the Console parser that runs in a web worker and analyzes the editor input
 * when it changes.
 * The parsed result contains the requests and errors which are used in the Console plugin.
 */
class ConsoleParsedRequestsProvider {
  constructor(workerProxyService, model) {
    this.workerProxyService = workerProxyService;
    this.model = model;
  }
  async getRequests() {
    var _parserResult$request;
    if (!this.model) {
      return [];
    }
    const parserResult = await this.workerProxyService.getParserResult(this.model.uri);
    return (_parserResult$request = parserResult === null || parserResult === void 0 ? void 0 : parserResult.requests) !== null && _parserResult$request !== void 0 ? _parserResult$request : [];
  }
  async getErrors() {
    var _parserResult$errors;
    if (!this.model) {
      return [];
    }
    const parserResult = await this.workerProxyService.getParserResult(this.model.uri);
    return (_parserResult$errors = parserResult === null || parserResult === void 0 ? void 0 : parserResult.errors) !== null && _parserResult$errors !== void 0 ? _parserResult$errors : [];
  }
}
exports.ConsoleParsedRequestsProvider = ConsoleParsedRequestsProvider;