"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCasesPersistableState = registerCasesPersistableState;
var _cases = require("../../common/constants/cases");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCasesPersistableState(cases, enabledFeatures, logger) {
  if (enabledFeatures.ad === true) {
    try {
      cases.attachmentFramework.registerPersistableState({
        id: _cases.CASE_ATTACHMENT_TYPE_ID_ANOMALY_SWIMLANE
      });
    } catch (error) {
      logger.warn(`ML failed to register cases persistable state for ${_cases.CASE_ATTACHMENT_TYPE_ID_ANOMALY_SWIMLANE}`);
    }
    try {
      cases.attachmentFramework.registerPersistableState({
        id: _cases.CASE_ATTACHMENT_TYPE_ID_ANOMALY_EXPLORER_CHARTS
      });
    } catch (error) {
      logger.warn(`ML failed to register cases persistable state for ${_cases.CASE_ATTACHMENT_TYPE_ID_ANOMALY_EXPLORER_CHARTS}`);
    }
    try {
      cases.attachmentFramework.registerPersistableState({
        id: _cases.CASE_ATTACHMENT_TYPE_ID_SINGLE_METRIC_VIEWER
      });
    } catch (error) {
      logger.warn(`ML failed to register cases persistable state for ${_cases.CASE_ATTACHMENT_TYPE_ID_SINGLE_METRIC_VIEWER}`);
    }
  }
}