"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertUserError = void 0;
var _boom = require("@hapi/boom");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _server = require("@kbn/task-manager-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Decides whether the thrown error is caused by a user-side misconfiguration
 * (missing saved object, unknown ML job/group, malformed job definition).
 *
 * Anything that doesn’t match these predicates will be treated as a framework
 * error and counted toward alert-execution SLOs.
 */
const isUserMisconfigurationError = err => {
  if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(err)) {
    return true;
  }
  if (err !== null && typeof err === 'object' && Object.hasOwn(err, 'statusCode') && err.statusCode === 404) {
    return true;
  }
  if ((0, _boom.isBoom)(err) && (err.output.statusCode === 404 || err.output.statusCode === 400)) {
    return true;
  }
  return false;
};
const assertUserError = err => {
  if (isUserMisconfigurationError(err)) {
    throw (0, _server.createTaskRunError)(err, _server.TaskErrorSource.USER);
  }
  throw err;
};
exports.assertUserError = assertUserError;