"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CLEAR_SELECTION_ACTION = void 0;
exports.createClearSelectionAction = createClearSelectionAction;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLEAR_SELECTION_ACTION = exports.CLEAR_SELECTION_ACTION = 'clearSelectionAction';
function createClearSelectionAction(getStartServices) {
  return {
    id: 'clear-selection-action',
    type: CLEAR_SELECTION_ACTION,
    getIconType(context) {
      return 'cross';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.clearSelectionTitle', {
      defaultMessage: 'Clear selection'
    }),
    shouldAutoExecute: () => Promise.resolve(false),
    async execute({
      updateCallback
    }) {
      updateCallback();
    },
    async isCompatible({
      updateCallback
    }) {
      return typeof updateCallback === 'function';
    }
  };
}