"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APPLY_TIME_RANGE_SELECTION_ACTION = void 0;
exports.createApplyTimeRangeSelectionAction = createApplyTimeRangeSelectionAction;
var _public = require("@kbn/dashboard-plugin/public");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _rxjs = require("rxjs");
var _triggers = require("./triggers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APPLY_TIME_RANGE_SELECTION_ACTION = exports.APPLY_TIME_RANGE_SELECTION_ACTION = 'applyTimeRangeSelectionAction';
const supportedApps = [_public.DASHBOARD_APP_ID];
function createApplyTimeRangeSelectionAction(getStartServices) {
  return {
    id: 'apply-time-range-selection',
    type: APPLY_TIME_RANGE_SELECTION_ACTION,
    getIconType(context) {
      return 'timeline';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.applyTimeRangeSelectionTitle', {
      defaultMessage: 'Apply time range selection'
    }),
    async execute({
      embeddable,
      data
    }) {
      if (!data) {
        throw new Error('No swim lane selection data provided');
      }
      const [, pluginStart] = await getStartServices();
      const timefilter = pluginStart.data.query.timefilter.timefilter;
      const {
        interval
      } = embeddable;
      if (!interval.getValue()) {
        throw new Error('Interval is required to set a time range');
      }
      let [from, to] = data.times;
      from = from * 1000;
      to = to * 1000;
      timefilter.setTime({
        from: (0, _moment.default)(from),
        to: (0, _moment.default)(to),
        mode: 'absolute'
      });
    },
    async isCompatible(context) {
      const [{
        application
      }] = await getStartServices();
      const appId = await (0, _rxjs.firstValueFrom)(application.currentAppId$);
      return (0, _triggers.isAnomalySwimlaneSelectionTriggerContext)(context) && supportedApps.includes(appId);
    }
  };
}