"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFilterListUI = exports.EditFilterList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _header = require("./header");
var _toolbar = require("./toolbar");
var _items_grid = require("../../../components/items_grid");
var _utils = require("./utils");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _locator = require("../../../../../common/constants/locator");
var _help_menu = require("../../../components/help_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/filter_lists/edit/edit_filter_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * React component for viewing and editing a filter list, a list of items
 * used for example to safe list items via a job detector rule.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_ITEMS_PER_PAGE = 50;

// Returns the list of items that match the query entered in the EuiSearchBar.
function getMatchingFilterItems(searchBarQuery, items) {
  if (items === undefined) {
    return [];
  }
  if (searchBarQuery === undefined) {
    return [...items];
  }

  // Convert the list of Strings into a list of Objects suitable for running through
  // the search bar query.
  const allItems = items.map(item => ({
    value: item
  }));
  const matchingObjects = _eui.EuiSearchBar.Query.execute(searchBarQuery, allItems, {
    defaultFields: ['value']
  });
  return matchingObjects.map(item => item.value);
}
function getActivePage(activePageState, itemsPerPage, numMatchingItems) {
  // Checks if supplied active page number from state is applicable for the number
  // of matching items in the grid, and if not returns the last applicable page number.
  let activePage = activePageState;
  const activePageStartIndex = itemsPerPage * activePageState;
  if (activePageStartIndex > numMatchingItems) {
    activePage = Math.max(Math.ceil(numMatchingItems / itemsPerPage) - 1, 0); // Sets to 0 for 0 matches.
  }
  return activePage;
}
class EditFilterListUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "returnToFiltersList", async () => {
      const {
        services: {
          http: {
            basePath
          },
          application: {
            navigateToUrl
          }
        }
      } = this.props.kibana;
      await navigateToUrl(`${basePath.get()}/app/management/ml/ad_settings/${_locator.ML_PAGES.FILTER_LISTS_MANAGE}`, true);
    });
    (0, _defineProperty2.default)(this, "loadFilterList", filterId => {
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      mlApi.filters.filters({
        filterId
      }).then(filter => {
        this.setLoadedFilterState(filter);
      }).catch(error => {
        this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.settings.filterLists.editFilterList.loadingDetailsOfFilterErrorMessage', {
          defaultMessage: 'An error occurred loading details of filter {filterId}',
          values: {
            filterId
          }
        }));
      });
    });
    (0, _defineProperty2.default)(this, "setLoadedFilterState", loadedFilter => {
      // Store the loaded filter so we can diff changes to the items when saving updates.
      this.setState(prevState => {
        const {
          itemsPerPage,
          searchQuery
        } = prevState;
        const matchingItems = getMatchingFilterItems(searchQuery, loadedFilter.items);
        const activePage = getActivePage(prevState.activePage, itemsPerPage, matchingItems.length);
        return {
          description: loadedFilter.description,
          items: loadedFilter.items !== undefined ? [...loadedFilter.items] : [],
          matchingItems,
          selectedItems: [],
          loadedFilter,
          isNewFilterIdInvalid: false,
          activePage,
          searchQuery,
          saveInProgress: false
        };
      });
    });
    (0, _defineProperty2.default)(this, "updateNewFilterId", newFilterId => {
      this.setState({
        newFilterId,
        isNewFilterIdInvalid: !(0, _utils.isValidFilterListId)(newFilterId)
      });
    });
    (0, _defineProperty2.default)(this, "updateDescription", description => {
      this.setState({
        description
      });
    });
    (0, _defineProperty2.default)(this, "addItems", itemsToAdd => {
      this.setState(prevState => {
        const {
          itemsPerPage,
          searchQuery
        } = prevState;
        const items = [...prevState.items];
        const alreadyInFilter = [];
        itemsToAdd.forEach(item => {
          if (items.indexOf(item) === -1) {
            items.push(item);
          } else {
            alreadyInFilter.push(item);
          }
        });
        items.sort((str1, str2) => {
          return str1.localeCompare(str2);
        });
        if (alreadyInFilter.length > 0) {
          const {
            toasts
          } = this.props.kibana.services.notifications;
          toasts.addWarning(_i18n.i18n.translate('xpack.ml.settings.filterLists.editFilterList.duplicatedItemsInFilterListWarningMessage', {
            defaultMessage: 'The following items were already in the filter list: {alreadyInFilter}',
            values: {
              alreadyInFilter
            }
          }));
        }
        const matchingItems = getMatchingFilterItems(searchQuery, items);
        const activePage = getActivePage(prevState.activePage, itemsPerPage, matchingItems.length);
        return {
          items,
          matchingItems,
          activePage,
          searchQuery
        };
      });
    });
    (0, _defineProperty2.default)(this, "deleteSelectedItems", () => {
      this.setState(prevState => {
        const {
          selectedItems,
          itemsPerPage,
          searchQuery
        } = prevState;
        const items = [...prevState.items];
        selectedItems.forEach(item => {
          const index = items.indexOf(item);
          if (index !== -1) {
            items.splice(index, 1);
          }
        });
        const matchingItems = getMatchingFilterItems(searchQuery, items);
        const activePage = getActivePage(prevState.activePage, itemsPerPage, matchingItems.length);
        return {
          items,
          matchingItems,
          selectedItems: [],
          activePage,
          searchQuery
        };
      });
    });
    (0, _defineProperty2.default)(this, "onSearchChange", ({
      query
    }) => {
      this.setState(prevState => {
        const {
          items,
          itemsPerPage
        } = prevState;
        const matchingItems = getMatchingFilterItems(query, items);
        const activePage = getActivePage(prevState.activePage, itemsPerPage, matchingItems.length);
        return {
          matchingItems,
          activePage,
          searchQuery: query
        };
      });
    });
    (0, _defineProperty2.default)(this, "setItemSelected", (item, isSelected) => {
      this.setState(prevState => {
        const selectedItems = [...prevState.selectedItems];
        const index = selectedItems.indexOf(item);
        if (isSelected === true && index === -1) {
          selectedItems.push(item);
        } else if (isSelected === false && index !== -1) {
          selectedItems.splice(index, 1);
        }
        return {
          selectedItems
        };
      });
    });
    (0, _defineProperty2.default)(this, "setActivePage", activePage => {
      this.setState({
        activePage
      });
    });
    (0, _defineProperty2.default)(this, "setItemsPerPage", itemsPerPage => {
      this.setState({
        itemsPerPage,
        activePage: 0
      });
    });
    (0, _defineProperty2.default)(this, "save", () => {
      this.setState({
        saveInProgress: true
      });
      const {
        loadedFilter,
        newFilterId,
        description,
        items
      } = this.state;
      const filterId = this.props.filterId !== undefined ? this.props.filterId : newFilterId;
      (0, _utils.saveFilterList)(this.props.kibana.services.notifications.toasts, this.props.kibana.services.mlServices.mlApi, filterId, description, items, loadedFilter).then(savedFilter => {
        this.setLoadedFilterState(savedFilter);
        this.returnToFiltersList();
      }).catch(error => {
        this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.settings.filterLists.editFilterList.savingFilterErrorMessage', {
          defaultMessage: 'An error occurred saving filter {filterId}',
          values: {
            filterId
          }
        }));
        this.setState({
          saveInProgress: false
        });
      });
    });
    this.state = {
      description: '',
      items: [],
      matchingItems: [],
      selectedItems: [],
      loadedFilter: {},
      newFilterId: '',
      isNewFilterIdInvalid: true,
      activePage: 0,
      itemsPerPage: DEFAULT_ITEMS_PER_PAGE,
      saveInProgress: false
    };
  }
  componentDidMount() {
    this.toastNotificationService = (0, _toast_notification_service.toastNotificationServiceProvider)(this.props.kibana.services.notifications.toasts);
    const filterId = this.props.filterId;
    if (filterId !== undefined) {
      this.loadFilterList(filterId);
    } else {
      this.setState({
        newFilterId: ''
      });
    }
  }
  render() {
    const {
      loadedFilter,
      newFilterId,
      isNewFilterIdInvalid,
      description,
      items,
      matchingItems,
      selectedItems,
      itemsPerPage,
      activePage,
      saveInProgress
    } = this.state;
    const {
      canCreateFilter,
      canDeleteFilter
    } = this.props;
    const totalItemCount = items !== undefined ? items.length : 0;
    const helpLink = this.props.kibana.services.docLinks.links.ml.customRules;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlPageFilterListEdit",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 337,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_header.EditFilterListHeader, {
      canCreateFilter: canCreateFilter,
      filterId: this.props.filterId,
      newFilterId: newFilterId,
      isNewFilterIdInvalid: isNewFilterIdInvalid,
      updateNewFilterId: this.updateNewFilterId,
      description: description,
      updateDescription: this.updateDescription,
      totalItemCount: totalItemCount,
      usedBy: loadedFilter.used_by,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 339,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_toolbar.EditFilterListToolbar, {
      canCreateFilter: canCreateFilter,
      canDeleteFilter: canDeleteFilter,
      onSearchChange: this.onSearchChange,
      addItems: this.addItems,
      deleteSelectedItems: this.deleteSelectedItems,
      selectedItemCount: selectedItems.length,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 358,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_items_grid.ItemsGrid, {
      totalItemCount: totalItemCount,
      items: matchingItems,
      selectedItems: selectedItems,
      itemsPerPage: itemsPerPage,
      setItemsPerPage: this.setItemsPerPage,
      setItemSelected: this.setItemSelected,
      activePage: activePage,
      setActivePage: this.setActivePage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 359,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 369,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 370,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": 'mlFilterListCancelButton',
      onClick: () => this.returnToFiltersList(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.settings.filterLists.editFilterList.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 381,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.save,
      disabled: saveInProgress === true || isNewFilterIdInvalid === true || canCreateFilter === false,
      fill: true,
      "data-test-subj": 'mlFilterListSaveButton',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.settings.filterLists.editFilterList.saveButtonLabel",
      defaultMessage: "Save",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 17
      }
    }))))), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
      docLink: helpLink,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 9
      }
    }));
  }
}
exports.EditFilterListUI = EditFilterListUI;
(0, _defineProperty2.default)(EditFilterListUI, "displayName", 'EditFilterList');
(0, _defineProperty2.default)(EditFilterListUI, "propTypes", {
  filterId: _propTypes.default.string,
  canCreateFilter: _propTypes.default.bool.isRequired,
  canDeleteFilter: _propTypes.default.bool.isRequired
});
const EditFilterList = exports.EditFilterList = (0, _public.withKibana)(EditFilterListUI);