"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlResultsServiceProvider = mlResultsServiceProvider;
exports.useMlResultsService = useMlResultsService;
var _result_service_rx = require("./result_service_rx");
var _results_service = require("./results_service");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is to retain the singleton behavior of the previous direct instantiation and export.
let mlResultsService;
function mlResultsServiceProvider(mlApi) {
  if (mlResultsService) return mlResultsService;
  mlResultsService = {
    ...(0, _results_service.resultsServiceProvider)(mlApi),
    ...(0, _result_service_rx.resultsServiceRxProvider)(mlApi)
  };
  return mlResultsService;
}
function useMlResultsService() {
  const mlApi = (0, _kibana.useMlApi)();
  return mlResultsServiceProvider(mlApi);
}