"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resultsApiProvider = void 0;
exports.useResultsApiService = useResultsApiService;
var _react = require("react");
var _app = require("../../../../common/constants/app");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Service for obtaining data for the ML Results dashboards.

const resultsApiProvider = httpService => ({
  getAnomaliesTableData(jobIds, criteriaFields, influencers, aggregationInterval, threshold, earliestMs, latestMs, dateFormatTz, maxRecords, maxExamples, influencersFilterQuery, functionDescription) {
    const body = JSON.stringify({
      jobIds,
      criteriaFields,
      influencers,
      aggregationInterval,
      threshold,
      earliestMs,
      latestMs,
      dateFormatTz,
      maxRecords,
      maxExamples,
      influencersFilterQuery,
      functionDescription
    });
    return httpService.http$({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/anomalies_table_data`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getMaxAnomalyScore(jobIds, earliestMs, latestMs) {
    const body = JSON.stringify({
      jobIds,
      earliestMs,
      latestMs
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/max_anomaly_score`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getCategoryDefinition(jobId, categoryId) {
    const body = JSON.stringify({
      jobId,
      categoryId
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/category_definition`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getCategoryExamples(jobId, categoryIds, maxExamples) {
    const body = JSON.stringify({
      jobId,
      categoryIds,
      maxExamples
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/category_examples`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  fetchPartitionFieldsValues(jobId, searchTerm, criteriaFields, earliestMs, latestMs, fieldsConfig) {
    const body = JSON.stringify({
      jobId,
      searchTerm,
      criteriaFields,
      earliestMs,
      latestMs,
      fieldsConfig
    });
    return httpService.http$({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/partition_fields_values`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  anomalySearch(query, jobIds) {
    const body = JSON.stringify({
      query,
      jobIds
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/anomaly_search`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  anomalySearch$(query, jobIds) {
    const body = JSON.stringify({
      query,
      jobIds
    });
    return httpService.http$({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/anomaly_search`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getCategoryStoppedPartitions(jobIds, fieldToBucket) {
    const body = JSON.stringify({
      jobIds,
      fieldToBucket
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/category_stopped_partitions`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getDatafeedResultChartData(jobId, start, end) {
    const body = JSON.stringify({
      jobId,
      start,
      end
    });
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/datafeed_results_chart`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getAnomalyCharts$(jobIds, influencers, threshold, earliestMs, latestMs, timeBounds, maxResults, numberOfPoints, influencersFilterQuery) {
    const body = JSON.stringify({
      jobIds,
      influencers,
      threshold,
      earliestMs,
      latestMs,
      maxResults,
      influencersFilterQuery,
      numberOfPoints,
      timeBounds
    });
    return httpService.http$({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/anomaly_charts`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getAnomalyRecords$(jobIds, criteriaFields, severity, earliestMs, latestMs, interval, functionDescription) {
    const body = JSON.stringify({
      jobIds,
      criteriaFields,
      threshold: severity,
      earliestMs,
      latestMs,
      interval,
      functionDescription
    });
    return httpService.http$({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/anomaly_records`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getTopInfluencers(payload) {
    const body = JSON.stringify(payload);
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/top_influencers`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getScoresByBucket(payload) {
    const body = JSON.stringify(payload);
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/view_by/scores_by_bucket`,
      method: 'POST',
      body,
      version: '1'
    });
  },
  getInfluencerValueMaxScoreByTime(payload) {
    const body = JSON.stringify(payload);
    return httpService.http({
      path: `${_app.ML_INTERNAL_BASE_PATH}/results/view_by/influencer_values_by_time`,
      method: 'POST',
      body,
      version: '1'
    });
  }
});
exports.resultsApiProvider = resultsApiProvider;
/**
 * Hooks for accessing {@link ResultsApiService} in React components.
 */
function useResultsApiService() {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  return (0, _react.useMemo)(() => resultsApiProvider(httpService), [httpService]);
}