"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewRouteFactory = exports.appRootRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _locator = require("../../../locator");
var _serverless_context = require("../../contexts/ml/serverless_context");
var _ml_nodes_check = require("../../ml_nodes_check");
var _ml_server_info = require("../../services/ml_server_info");
var _breadcrumbs = require("../breadcrumbs");
var _router = require("../router");
var _use_resolver = require("../use_resolver");
var _resolvers = require("../resolvers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/overview_ml.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverviewMlPage = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../overview/overview_ml_page'))));
const overviewRouteFactory = (navigateToPath, basePath) => ({
  id: 'overview',
  path: (0, _router.createPath)(_locator.ML_PAGES.OVERVIEW),
  title: _i18n.i18n.translate('xpack.ml.overview.overviewLabel', {
    defaultMessage: 'Overview'
  }),
  enableDatePicker: true,
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 28
    }
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.overview.overviewLabel', {
      defaultMessage: 'Overview'
    })
  }],
  'data-test-subj': 'mlAppPageOverview'
});
exports.overviewRouteFactory = overviewRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetMlInfo'], {
    getMlNodeCount: _ml_nodes_check.getMlNodeCount,
    loadMlServerInfo: _ml_server_info.loadMlServerInfo,
    initSavedObjects: _resolvers.initSavedObjects
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(OverviewMlPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })));
};
const appRootRouteFactory = (navigateToPath, basePath) => ({
  id: '',
  path: '/',
  render: () => /*#__PURE__*/_react.default.createElement(Page, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 17
    }
  }),
  breadcrumbs: []
});
exports.appRootRouteFactory = appRootRouteFactory;
const Page = () => {
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _serverless_context.useEnabledFeatures)();
  if (isADEnabled === false && isDFAEnabled === false && isNLPEnabled === true) {
    // if only NLP is enabled, redirect to the trained models page.
    // in the search serverless project, the overview page is blank, so we
    // need to redirect to the trained models page instead
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: (0, _router.createPath)(_locator.ML_PAGES.TRAINED_MODELS_MANAGE),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _router.createPath)(_locator.ML_PAGES.OVERVIEW),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 10
    }
  });
};