"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClassColor = getClassColor;
exports.getClassIcon = getClassIcon;
exports.getClassLabel = getClassLabel;
exports.getNerOutputComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _inference_base = require("../inference_base");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_models/models/ner/ner_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const badgeColorPaletteBorder = (0, _eui.euiPaletteColorBlind)();
const badgeColorPaletteBehindText = (0, _eui.euiPaletteColorBlindBehindText)();
const ICON_PADDING = '2px';
const PROBABILITY_SIG_FIGS = 3;
const ENTITY_TYPE_NAMES = ['PER', 'LOC', 'ORG', 'MISC'];
const isEntityTypeName = name => ENTITY_TYPE_NAMES.includes(name);
const ENTITY_TYPES = {
  PER: {
    label: 'Person',
    icon: 'user',
    // Amsterdam color
    colorIndex: 5
  },
  LOC: {
    label: 'Location',
    icon: 'visMapCoordinate',
    // Amsterdam color
    colorIndex: 1
  },
  ORG: {
    label: 'Organization',
    icon: 'home',
    // Amsterdam color
    colorIndex: 0
  },
  MISC: {
    label: 'Miscellaneous',
    icon: 'question',
    // Amsterdam color
    colorIndex: 7
  }
};
const UNKNOWN_ENTITY_TYPE = {
  label: '',
  icon: 'question',
  // Amsterdam color
  colorIndex: 5
};

// Amsterdam
// ['#6dccb1', '#79aad9', '#ee789d', '#a987d1', '#e4a6c7', '#f1d86f', '#d2c0a0', '#f5a35c', '#c47c6c', '#ff7e62']
// Borealis
// ['#00BEB8', '#98E6E2', '#599DFF', '#B4D5FF', '#ED6BA2', '#FFBED5', '#F66D64', '#FFC0B8', '#E6AB01', '#FCD279']
const amsterdam2BorealisColorMap = new Map([[0, 0], [1, 2], [5, 9], [7, 8]]);
const getNerOutputComponent = inferrer => /*#__PURE__*/_react.default.createElement(NerOutput, {
  inferrer: inferrer,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 66
  }
});
exports.getNerOutputComponent = getNerOutputComponent;
const NerOutput = ({
  inferrer
}) => {
  const result = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (!result) {
    return null;
  }
  if (inferrer.getInputType() === _inference_base.INPUT_TYPE.INDEX) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, result.map(r => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Lines, {
      result: r,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(Lines, {
    result: result[0],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 10
    }
  });
};
const Lines = ({
  result
}) => {
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs', {
    unit: 'px'
  }).fontSize;
  const lineSplit = [];
  result.response.forEach(({
    value,
    entity
  }) => {
    if (entity === null) {
      const lines = value.split(/(\n)/).map(line => line === '\n' ? /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 41
        }
      }) : /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 50
        }
      }, line));
      lineSplit.push(...lines);
    } else {
      lineSplit.push(/*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: getClassIcon(entity.class_name),
          style: {
            marginRight: ICON_PADDING,
            verticalAlign: 'text-top'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 17
          }
        }), value), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
          margin: "none",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement("div", {
          style: {
            fontSize: euiFontSizeXS,
            marginTop: ICON_PADDING
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.testModelsFlyout.ner.output.typeTitle",
          defaultMessage: "Type",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 142,
            columnNumber: 19
          }
        }), ": ", getClassLabel(entity.class_name)), /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.testModelsFlyout.ner.output.probabilityTitle",
          defaultMessage: "Probability",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 19
          }
        }), ": ", Number(entity.class_probability).toPrecision(PROBABILITY_SIG_FIGS)))),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(EntityBadge, {
        entity: entity,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 11
        }
      }, value)));
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      lineHeight: '24px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 10
    }
  }, lineSplit);
};
const EntityBadge = ({
  entity,
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiFontSizeXS = (0, _eui.useEuiFontSize)('xs').fontSize;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: getClassColor(entity.class_name, euiTheme.flags.hasVisColorAdjustment),
    style: {
      marginRight: ICON_PADDING,
      marginTop: `-${ICON_PADDING}`,
      // For Amsterdam, add a border to the badge to improve contrast with the background.
      ...(euiTheme.flags.hasVisColorAdjustment ? {
        border: `1px solid ${getClassColor(entity.class_name, euiTheme.flags.hasVisColorAdjustment, true)}`
      } : {}),
      fontSize: euiFontSizeXS,
      padding: '0px 6px',
      pointerEvents: 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: getClassIcon(entity.class_name),
    style: {
      marginRight: ICON_PADDING,
      marginTop: ICON_PADDING
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, children)));
};
function getClassIcon(className) {
  var _entity$icon;
  const entity = ENTITY_TYPES[className];
  return (_entity$icon = entity === null || entity === void 0 ? void 0 : entity.icon) !== null && _entity$icon !== void 0 ? _entity$icon : UNKNOWN_ENTITY_TYPE.icon;
}
function getClassLabel(className) {
  var _entity$label;
  const entity = ENTITY_TYPES[className];
  return (_entity$label = entity === null || entity === void 0 ? void 0 : entity.label) !== null && _entity$label !== void 0 ? _entity$label : className;
}
function getClassColor(className, hasVisColorAdjustment, border = false) {
  var _amsterdam2BorealisCo;
  const colorIndex = isEntityTypeName(className) ? ENTITY_TYPES[className].colorIndex : UNKNOWN_ENTITY_TYPE.colorIndex;

  // map colors from Amsterdam to Borealis if necessary
  const themeColorIndex = hasVisColorAdjustment ? colorIndex : (_amsterdam2BorealisCo = amsterdam2BorealisColorMap.get(colorIndex)) !== null && _amsterdam2BorealisCo !== void 0 ? _amsterdam2BorealisCo : colorIndex;
  return border ? badgeColorPaletteBorder[themeColorIndex] : badgeColorPaletteBehindText[themeColorIndex];
}