"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryPreviewChart = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _common = require("@kbn/field-formats-plugin/common");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
var _memory_item_colors = require("../memory_item_colors");
var _kibana = require("../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/memory_usage/nodes_overview/memory_preview_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MemoryPreviewChart = ({
  memoryOverview
}) => {
  const bytesFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const {
    services: {
      charts: chartsService
    }
  } = (0, _kibana.useMlKibana)();
  const chartBaseTheme = chartsService.theme.useChartsBaseTheme();
  const groups = (0, _react.useMemo)(() => ({
    jvm: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.jvmHeapSIze', {
        defaultMessage: 'JVM heap size'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('jvm-heap-size')
    },
    trained_models: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsMemoryUsage', {
        defaultMessage: 'Trained models'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('trained-model')
    },
    anomaly_detection: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.adMemoryUsage', {
        defaultMessage: 'Anomaly detection jobs'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('anomaly-detector')
    },
    dfa_training: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.dfaMemoryUsage', {
        defaultMessage: 'Data frame analytics jobs'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('data-frame-analytics')
    },
    available: {
      name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.availableMemory', {
        defaultMessage: 'Estimated available memory'
      }),
      color: (0, _memory_item_colors.getMemoryItemColor)('estimated-available-memory')
    }
  }), []);
  const chartData = [{
    x: 0,
    y: memoryOverview.trained_models.total,
    g: groups.trained_models.name
  }, {
    x: 0,
    y: memoryOverview.anomaly_detection.total,
    g: groups.anomaly_detection.name
  }, {
    x: 0,
    y: memoryOverview.dfa_training.total,
    g: groups.dfa_training.name
  }, {
    x: 0,
    y: memoryOverview.machine_memory.total - memoryOverview.machine_memory.jvm - memoryOverview.trained_models.total - memoryOverview.dfa_training.total - memoryOverview.anomaly_detection.total,
    g: groups.available.name
  }, {
    x: 0,
    y: memoryOverview.machine_memory.jvm,
    g: groups.jvm.name
  }];
  const barSeriesColorAccessor = ({
    specId,
    yAccessor,
    splitAccessors
  }) => {
    const group = splitAccessors.get('g');
    return Object.values(groups).find(v => v.name === group).color;
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: ['100%', 50],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: ({
      value
    }) => _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.memoryBreakdown', {
      defaultMessage: 'Approximate memory breakdown'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: {
      chartMargins: _charts.LIGHT_THEME.chartMargins
    },
    baseTheme: chartBaseTheme,
    rotation: 90,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "ml_memory",
    position: _charts.Position.Bottom,
    hide: true,
    tickFormat: d => bytesFormatter(d),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "line_annotation",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: memoryOverview.ml_max_in_bytes,
      details: bytesFormatter(memoryOverview.ml_max_in_bytes),
      header: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.mlMaxMemory', {
        defaultMessage: 'Maximum memory permitted for ML native processes'
      })
    }],
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowDown",
      "aria-label": _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.mlMaxMemoryAriaLabel', {
        defaultMessage: 'Maximum memory permitted for ML native processes {bytes}',
        values: {
          bytes: bytesFormatter(memoryOverview.ml_max_in_bytes)
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 11
      }
    }),
    markerPosition: _charts.Position.Top,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "bars",
    xScaleType: _charts.ScaleType.Linear,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    splitSeriesAccessors: ['g'],
    stackAccessors: ['x'],
    data: chartData,
    color: barSeriesColorAccessor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }));
};
exports.MemoryPreviewChart = MemoryPreviewChart;