"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfluencersSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _job_creator_context = require("../../../job_creator_context");
var _general = require("../../../../../common/job_creator/util/general");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/influencers/influencers_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InfluencersSelect = ({
  fields,
  changeHandler,
  selectedInfluencers,
  titleId
}) => {
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const {
    renderOption,
    optionCss
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  const options = [...(0, _general.createFieldOptions)(fields, jobCreator.additionalFields), ...(0, _general.createMlcategoryFieldOption)(jobCreator.categorizationFieldName)].map(o => ({
    ...o,
    css: optionCss
  }));
  const selection = selectedInfluencers.map(i => ({
    label: i
  }));
  function onChange(selectedOptions) {
    changeHandler(selectedOptions.map(o => o.label));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: false,
    options: options,
    selectedOptions: selection,
    onChange: onChange,
    isClearable: false,
    "data-test-subj": "mlInfluencerSelect",
    renderOption: renderOption,
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
};
exports.InfluencersSelect = InfluencersSelect;