"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MMLCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../../job_creator_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/components/advanced_section/components/mml_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MMLCallout = () => {
  const {
    jobCreator,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [highCardinality, setHighCardinality] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    var _jobValidator$latestV, _jobValidator$latestV2, _jobValidator$latestV3;
    const value = (_jobValidator$latestV = (_jobValidator$latestV2 = jobValidator.latestValidationResult) === null || _jobValidator$latestV2 === void 0 ? void 0 : (_jobValidator$latestV3 = _jobValidator$latestV2.highCardinality) === null || _jobValidator$latestV3 === void 0 ? void 0 : _jobValidator$latestV3.value) !== null && _jobValidator$latestV !== void 0 ? _jobValidator$latestV : null;
    setHighCardinality(value);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return jobCreator.modelPlot && highCardinality !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.mmlWarning.title",
      defaultMessage: "Proceed with caution!",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 9
      }
    }),
    color: "warning",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.mmlWarning.message",
    defaultMessage: "Creating model plots is resource intensive and not recommended where the cardinality of the selected fields is greater than 100. Estimated cardinality for this job is {highCardinality}. If you enable model plot with this configuration we recommend you use a dedicated results index.",
    values: {
      highCardinality
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }))) : null;
};
exports.MMLCallout = MMLCallout;