"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationExtractor = void 0;
var _std = require("@kbn/std");
var _fields_utils = require("../../../../../common/util/fields_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class VisualizationExtractor {
  constructor() {}
  async getResultLayersFromEmbeddable(embeddable) {
    var _embeddable$dataViews, _embeddable$dataViews2;
    const layers = [];
    const dataViews = (_embeddable$dataViews = (_embeddable$dataViews2 = embeddable.dataViews$) === null || _embeddable$dataViews2 === void 0 ? void 0 : _embeddable$dataViews2.value) !== null && _embeddable$dataViews !== void 0 ? _embeddable$dataViews : [];

    // Keep track of geoFields for layers as they can be repeated
    const layerGeoFields = {};
    await (0, _std.asyncForEach)(embeddable.getLayerList(), async layer => {
      const geoField = layer.getGeoFieldNames().length ? layer.getGeoFieldNames()[0] : undefined;
      const dataViewId = layer.getIndexPatternIds().length ? layer.getIndexPatternIds()[0] : undefined;
      const layerDisplayName = await layer.getDisplayName();
      const layerId = layer.getId();
      const query = layer.getQuery();
      if (geoField && dataViewId && layerGeoFields[geoField] === undefined) {
        layerGeoFields[geoField] = true;
        const dataView = dataViews.find(dv => dv.id === dataViewId);
        layers.push({
          layerId,
          layerDisplayName,
          geoField,
          dataViewId,
          dataView,
          query,
          ...(dataView ? {
            splitFieldOptions: await this.getSplitFieldOptions(dataView)
          } : {
            splitFieldOptions: []
          })
        });
      }
    });
    return layers;
  }
  async getSplitFieldOptions(dataView) {
    var _dataView$fields$getA;
    const sortedFields = (_dataView$fields$getA = dataView.fields.getAll().sort((a, b) => a.name.localeCompare(b.name))) !== null && _dataView$fields$getA !== void 0 ? _dataView$fields$getA : [];
    const categoryFields = sortedFields.filter(f => _fields_utils.categoryFieldTypes.some(type => {
      var _f$esTypes;
      return (_f$esTypes = f.esTypes) === null || _f$esTypes === void 0 ? void 0 : _f$esTypes.includes(type);
    }));
    return categoryFields.map(field => ({
      label: field.name,
      field: field.name
    }));
  }
}
exports.VisualizationExtractor = VisualizationExtractor;