"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractJobDetails = extractJobDetails;
var _react = _interopRequireDefault(require("react"));
var _string_utils = require("../../../../util/string_utils");
var _format_values = require("./format_values");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ml_alerting_flyout = require("../../../../../alerting/ml_alerting_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/job_details/extract_job_details.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function extractJobDetails(job, basePath, refreshJobList) {
  var _job$custom_settings, _job$alerting_rules;
  if (Object.keys(job).length === 0) {
    return {};
  }
  const general = {
    id: 'general',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.generalTitle', {
      defaultMessage: 'General'
    }),
    position: 'left',
    items: (0, _format_values.filterObjects)(job, true).map(_format_values.formatValues)
  };
  const {
    job_tags: tags,
    custom_urls: urls,
    ...settings
  } = (_job$custom_settings = job.custom_settings) !== null && _job$custom_settings !== void 0 ? _job$custom_settings : {};
  const customUrl = {
    id: 'customUrl',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.customUrlsTitle', {
      defaultMessage: 'Custom URLs'
    }),
    position: 'right',
    items: urls ? urls.map(cu => [cu.url_name, cu.url_value, cu.time_range]) : []
  };
  const customSettings = {
    id: 'analysisConfig',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.customSettingsTitle', {
      defaultMessage: 'Custom settings'
    }),
    position: 'right',
    items: settings ? (0, _format_values.filterObjects)(settings, true, true).map(_format_values.formatValues) : []
  };
  const jobTags = {
    id: 'analysisConfig',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.jobTagsTitle', {
      defaultMessage: 'Job tags'
    }),
    position: 'right',
    items: tags ? (0, _format_values.filterObjects)(tags) : []
  };
  const node = {
    id: 'node',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.nodeTitle', {
      defaultMessage: 'Node'
    }),
    position: 'right',
    items: []
  };
  if (job.node) {
    node.items.push(['name', job.node.name]);
  }
  const calendars = {
    id: 'calendars',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.calendarsTitle', {
      defaultMessage: 'Calendars'
    }),
    position: 'right',
    items: []
  };
  if (job.calendars) {
    calendars.items = job.calendars.map(c => ['', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: basePath.prepend(`/app/management/ml/ad_settings/calendars_list/edit_calendar/${c}?_g=()`),
      "data-test-subj": `mlJobDetailsCalendar-${c}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    }, c)]);
    // remove the calendars list from the general section
    // so not to show it twice.
    const i = general.items.findIndex(item => item[0] === 'calendars');
    if (i >= 0) {
      general.items.splice(i, 1);
    }
  }
  const alertRules = {
    id: 'alertRules',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.alertRulesTitle', {
      defaultMessage: 'Alert rules'
    }),
    position: 'right',
    items: ((_job$alerting_rules = job.alerting_rules) !== null && _job$alerting_rules !== void 0 ? _job$alerting_rules : []).map(v => {
      return ['', /*#__PURE__*/_react.default.createElement(_ml_alerting_flyout.EditAlertRule, {
        initialAlert: v,
        onSave: refreshJobList,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 19
        }
      })];
    })
  };
  if (job.alerting_rules) {
    // remove the alerting_rules list from the general section
    // so not to show it twice.
    const i = general.items.findIndex(item => item[0] === 'alerting_rules');
    if (i >= 0) {
      general.items.splice(i, 1);
    }
  }
  const detectors = {
    id: 'detectors',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.detectorsTitle', {
      defaultMessage: 'Detectors'
    }),
    position: 'left',
    items: []
  };
  if (job.analysis_config && job.analysis_config.detectors) {
    detectors.items.push(...job.analysis_config.detectors.map(d => {
      const stringifiedDtr = (0, _string_utils.detectorToString)(d);
      return [stringifiedDtr, stringifiedDtr !== d.detector_description ? d.detector_description : ''];
    }));
  }
  const influencers = {
    id: 'influencers',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.influencersTitle', {
      defaultMessage: 'Influencers'
    }),
    position: 'left',
    items: job.analysis_config.influencers.map(i => ['', i])
  };
  const analysisConfig = {
    id: 'analysisConfig',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.analysisConfigTitle', {
      defaultMessage: 'Analysis config'
    }),
    position: 'left',
    items: (0, _format_values.filterObjects)(job.analysis_config)
  };
  const analysisLimits = {
    id: 'analysisLimits',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.analysisLimitsTitle', {
      defaultMessage: 'Analysis limits'
    }),
    position: 'left',
    items: (0, _format_values.filterObjects)(job.analysis_limits)
  };
  const dataDescription = {
    id: 'dataDescription',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.dataDescriptionTitle', {
      defaultMessage: 'Data description'
    }),
    position: 'right',
    items: (0, _format_values.filterObjects)(job.data_description)
  };
  const datafeed = {
    id: 'datafeed',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.datafeedTitle', {
      defaultMessage: 'Datafeed'
    }),
    position: 'left',
    items: (0, _format_values.filterObjects)(job.datafeed_config || {}, true, true)
  };
  if (job.node) {
    datafeed.items.push(['node', JSON.stringify(job.node)]);
  }
  if (job.datafeed_config && job.datafeed_config.timing_stats) {
    // remove the timing_stats list from the datafeed section
    // so not to show it twice.
    const i = datafeed.items.findIndex(item => item[0] === 'timing_stats');
    if (i >= 0) {
      datafeed.items.splice(i, 1);
    }
  }
  const counts = {
    id: 'counts',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.countsTitle', {
      defaultMessage: 'Counts'
    }),
    position: 'left',
    items: (0, _format_values.filterObjects)(job.data_counts).map(_format_values.formatValues)
  };
  const modelSizeStats = {
    id: 'modelSizeStats',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.modelSizeStatsTitle', {
      defaultMessage: 'Model size stats'
    }),
    position: 'right',
    items: (0, _format_values.filterObjects)(job.model_size_stats).map(_format_values.formatValues)
  };
  const jobTimingStats = {
    id: 'jobTimingStats',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.jobTimingStatsTitle', {
      defaultMessage: 'Job timing stats'
    }),
    position: 'left',
    items: (0, _format_values.filterObjects)(job.timing_stats).map(_format_values.formatValues)
  };
  const datafeedTimingStats = {
    id: 'datafeedTimingStats',
    title: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.datafeedTimingStatsTitle', {
      defaultMessage: 'Timing stats'
    }),
    position: 'right',
    items: job.datafeed_config && job.datafeed_config.timing_stats ? (0, _format_values.filterObjects)(job.datafeed_config.timing_stats).filter(o => o[0] !== 'total_search_time_ms') // remove total_search_time_ms as average_search_time_per_bucket_ms is better
    .map(_format_values.formatValues) : []
  };
  return {
    general,
    customUrl,
    node,
    calendars,
    detectors,
    influencers,
    analysisConfig,
    analysisLimits,
    dataDescription,
    customSettings,
    jobTags,
    datafeed,
    counts,
    modelSizeStats,
    jobTimingStats,
    datafeedTimingStats,
    alertRules
  };
}