"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJobSelection = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = require("react");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
var _explorer_utils = require("../explorer_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useJobSelection = () => {
  const {
    anomalyExplorerCommonStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const selectedJobs = (0, _useObservable.default)(anomalyExplorerCommonStateService.selectedJobs$, anomalyExplorerCommonStateService.selectedJobs);
  const selectedGroups = (0, _useObservable.default)(anomalyExplorerCommonStateService.selectedGroups$, anomalyExplorerCommonStateService.selectedGroups);
  const mergedGroupsAndJobsIds = (0, _react.useMemo)(() => (0, _explorer_utils.getMergedGroupsAndJobsIds)(selectedGroups, selectedJobs), [selectedGroups, selectedJobs]);
  return {
    selectedJobs,
    selectedGroups,
    mergedGroupsAndJobsIds
  };
};
exports.useJobSelection = useJobSelection;