"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Explorer = void 0;
exports.getDefaultPanelsState = getDefaultPanelsState;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _help_popover = require("../components/help_popover");
var _annotations_table = require("../components/annotations/annotations_table");
var _components = require("./components");
var _influencers_list = require("../components/influencers_list");
var _checkbox_showcharts = require("../components/controls/checkbox_showcharts");
var _job_selector = require("../components/job_selector");
var _select_interval = require("../components/controls/select_interval/select_interval");
var _select_severity = require("../components/controls/select_severity");
var _explorer_query_bar = require("./components/explorer_query_bar/explorer_query_bar");
var _explorer_utils = require("./explorer_utils");
var _anomaly_timeline = require("./anomaly_timeline");
var _explorer_constants = require("./explorer_constants");
var _anomalies_table = require("../components/anomalies_table/anomalies_table");
var _anomaly_context_menu = require("./anomaly_context_menu");
var _toast_notification_service = require("../services/toast_notification_service");
var _kibana = require("../contexts/kibana");
var _anomaly_explorer_context = require("./anomaly_explorer_context");
var _storage = require("../../../common/types/storage");
var _alerts = require("./alerts");
var _index_service = require("../util/index_service");
var _use_job_selection = require("./hooks/use_job_selection");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
// Anomalies Table
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnnotationFlyout = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../components/annotations/annotation_flyout')))).AnnotationFlyout
}));
const AnomaliesMap = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./anomalies_map')))).AnomaliesMap
}));
const ExplorerChartsContainer = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./explorer_charts/explorer_charts_container')))).ExplorerChartsContainer
}));
const ExplorerPage = ({
  children,
  jobSelectorProps,
  filterActive,
  filterPlaceHolder,
  indexPattern,
  dataViews,
  queryString,
  updateLanguage
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 116,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
  css: {
    width: '100%'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_job_selector.JobSelector, (0, _extends2.default)({}, jobSelectorProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 118,
    columnNumber: 9
  }
})), indexPattern && updateLanguage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_explorer_query_bar.ExplorerQueryBar, {
  filterActive: !!filterActive,
  filterPlaceHolder: filterPlaceHolder,
  indexPattern: indexPattern,
  dataViews: dataViews,
  queryString: queryString,
  updateLanguage: updateLanguage,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 13
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 130,
    columnNumber: 13
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 131,
    columnNumber: 13
  }
})) : null)), children);
function getDefaultPanelsState() {
  return {
    topInfluencers: {
      isCollapsed: false,
      size: 20
    },
    mainPage: {
      isCollapsed: false,
      size: 80
    }
  };
}
const Explorer = ({
  showCharts,
  severity,
  stoppedPartitions,
  selectedJobsRunning,
  timefilter,
  timeBuckets,
  selectedCells,
  explorerState,
  overallSwimlaneData,
  swimLaneSeverity,
  noInfluencersConfigured
}) => {
  var _tableData$anomalies, _swimLaneSeverity$len, _tableData$anomalies2;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const [anomalyExplorerPanelState, setAnomalyExplorerPanelState] = (0, _mlLocalStorage.useStorage)(_storage.ML_ANOMALY_EXPLORER_PANELS, {
    topInfluencers: {
      isCollapsed: false,
      size: 20
    },
    mainPage: {
      size: 80
    }
  });
  const topInfluencersPanelRef = (0, _react.useRef)(null);
  const collapseFn = (0, _react.useRef)();
  const panelsInitialized = (0, _react.useRef)(false);
  (0, _react.useEffect)(
  /**
   * Preserve collapsible panel state on page load.
   * TODO Remove when https://github.com/elastic/eui/issues/4736 is resolved.
   */
  function initTopInfluencersPanelCollapse() {
    if (panelsInitialized.current || !collapseFn.current || !topInfluencersPanelRef.current) return;
    panelsInitialized.current = true;
    if (anomalyExplorerPanelState.topInfluencers.isCollapsed) {
      setTimeout(() => {
        if (collapseFn.current) {
          collapseFn.current();
        }
      }, 0);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [collapseFn.current, panelsInitialized, topInfluencersPanelRef.current, anomalyExplorerPanelState]);
  const onPanelWidthChange = (0, _react.useCallback)(newSizes => {
    setAnomalyExplorerPanelState({
      mainPage: {
        size: newSizes.mainPage
      },
      topInfluencers: {
        ...anomalyExplorerPanelState.topInfluencers,
        size: newSizes.topInfluencers
      }
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [anomalyExplorerPanelState]);
  const onToggleCollapsed = (0, _react.useCallback)(() => {
    panelsInitialized.current = true;
    const isCurrentlyCollapsed = anomalyExplorerPanelState.topInfluencers.isCollapsed;
    if (isCurrentlyCollapsed) {
      setAnomalyExplorerPanelState({
        mainPage: {
          size: 80
        },
        topInfluencers: {
          size: 20,
          isCollapsed: !isCurrentlyCollapsed
        }
      });
      return;
    }
    setAnomalyExplorerPanelState({
      mainPage: anomalyExplorerPanelState.mainPage,
      topInfluencers: {
        ...anomalyExplorerPanelState.topInfluencers,
        isCollapsed: !isCurrentlyCollapsed
      }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [anomalyExplorerPanelState]);
  const {
    displayDangerToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    anomalyTimelineStateService,
    anomalyExplorerCommonStateService,
    chartsStateService,
    anomalyDetectionAlertsStateService,
    anomalyTableService,
    annotationsStateService,
    influencersStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const tableData = (0, _useObservable.default)(anomalyTableService.tableData$, anomalyTableService.tableData);
  const tableError = (0, _useObservable.default)(anomalyTableService.tableError$, anomalyTableService.tableError);
  const htmlIdGen = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)(), []);
  const [language, updateLanguage] = (0, _react.useState)(_explorer_query_bar.DEFAULT_QUERY_LANG);
  const [sourceIndicesWithGeoFields, setSourceIndicesWithGeoFields] = (0, _react.useState)({});
  const [dataViews, setDataViews] = (0, _react.useState)();
  const filterSettings = (0, _useObservable.default)(anomalyExplorerCommonStateService.filterSettings$, anomalyExplorerCommonStateService.filterSettings);
  const {
    selectedJobs,
    selectedGroups,
    mergedGroupsAndJobsIds
  } = (0, _use_job_selection.useJobSelection)();
  const alertsData = (0, _useObservable.default)(anomalyDetectionAlertsStateService.anomalyDetectionAlerts$, []);
  const applyFilter = (0, _react.useCallback)((fieldName, fieldValue, action) => {
    const {
      filterActive,
      queryString
    } = filterSettings;
    const indexPattern = explorerState.indexPattern;
    let newQueryString = '';
    const operator = 'and ';
    const sanitizedFieldName = (0, _explorer_utils.escapeParens)(fieldName);
    const sanitizedFieldValue = (0, _explorer_utils.escapeDoubleQuotes)(fieldValue);
    if (action === _explorer_constants.FILTER_ACTION.ADD) {
      // Don't re-add if already exists in the query
      const queryPattern = (0, _explorer_utils.getQueryPattern)(fieldName, fieldValue);
      if (queryString.match(queryPattern) !== null) {
        return;
      }
      newQueryString = `${queryString ? `${queryString} ${operator}` : ''}${sanitizedFieldName}:"${sanitizedFieldValue}"`;
    } else if (action === _explorer_constants.FILTER_ACTION.REMOVE) {
      if (filterActive === false) {
        return;
      } else {
        newQueryString = (0, _explorer_utils.removeFilterFromQueryString)(queryString, sanitizedFieldName, sanitizedFieldValue);
      }
    }
    try {
      const {
        clearSettings,
        settings
      } = (0, _explorer_query_bar.getKqlQueryValues)({
        inputString: `${newQueryString}`,
        queryLanguage: language,
        indexPattern: indexPattern
      });
      if (clearSettings === true) {
        anomalyExplorerCommonStateService.clearFilterSettings();
      } else {
        anomalyExplorerCommonStateService.setFilterSettings(settings);
      }
    } catch (e) {
      console.log('Invalid query syntax from table', e); // eslint-disable-line no-console

      displayDangerToast(_i18n.i18n.translate('xpack.ml.explorer.invalidKuerySyntaxErrorMessageFromTable', {
        defaultMessage: 'Invalid syntax in query bar. The input must be valid Kibana Query Language (KQL)'
      }));
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [explorerState, language, filterSettings]);
  const {
    services: {
      charts: chartsService,
      data: {
        dataViews: dataViewsService
      },
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const mlIndexUtils = (0, _index_service.useMlIndexUtils)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const {
    filterPlaceHolder,
    indexPattern,
    loading
  } = explorerState;
  const influencers = (0, _useObservable.default)(influencersStateService.influencers$, influencersStateService.influencers);
  const influencersLoading = (0, _useObservable.default)(influencersStateService.isLoading$, true);
  const chartsData = (0, _useObservable.default)(chartsStateService.getChartsData$(), chartsStateService.getChartsData());
  const {
    filterActive,
    queryString
  } = filterSettings;
  const isOverallSwimLaneLoading = (0, _useObservable.default)(anomalyTimelineStateService.isOverallSwimLaneLoading$(), true);
  const isViewBySwimLaneLoading = (0, _useObservable.default)(anomalyTimelineStateService.isViewBySwimLaneLoading$(), true);
  const isDataLoading = loading || isOverallSwimLaneLoading || isViewBySwimLaneLoading;
  const swimLaneBucketInterval = (0, _useObservable.default)(anomalyTimelineStateService.getSwimLaneBucketInterval$(), anomalyTimelineStateService.getSwimLaneBucketInterval());
  const {
    annotationsData,
    totalCount: allAnnotationsCnt,
    error: annotationsError
  } = (0, _useObservable.default)(annotationsStateService.annotationsTable$, annotationsStateService.annotationsTable);
  const annotationsCnt = Array.isArray(annotationsData) ? annotationsData.length : 0;
  const badge = (allAnnotationsCnt !== null && allAnnotationsCnt !== void 0 ? allAnnotationsCnt : 0) > annotationsCnt ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: 'hollow',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.annotationsOutOfTotalCountTitle",
    defaultMessage: "First {visibleCount} out of a total of {totalCount}",
    values: {
      visibleCount: annotationsCnt,
      totalCount: allAnnotationsCnt
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: 'hollow',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 424,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.annotationsTitleTotalCount",
    defaultMessage: "Total: {count}",
    values: {
      count: annotationsCnt
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 9
    }
  }));
  const handleJobSelectionChange = (0, _react.useCallback)(({
    jobIds,
    time
  }) => {
    anomalyExplorerCommonStateService.setSelectedJobs(jobIds, time);
  }, [anomalyExplorerCommonStateService]);
  const selectedJobIds = Array.isArray(selectedJobs) ? selectedJobs.map(job => job.id) : [];
  const jobSelectorProps = {
    dateFormatTz: (0, _explorer_utils.getDateFormatTz)(uiSettings),
    onSelectionChange: handleJobSelectionChange,
    selectedJobIds,
    selectedGroups,
    selectedJobs
  };
  const noJobsSelected = !selectedJobs || selectedJobs.length === 0;
  const hasResults = !!(overallSwimlaneData !== null && overallSwimlaneData !== void 0 && overallSwimlaneData.points) && overallSwimlaneData.points.length > 0;
  const hasResultsWithAnomalies = hasResults && overallSwimlaneData.points.some(v => v.value > 0) || tableData && ((_tableData$anomalies = tableData.anomalies) === null || _tableData$anomalies === void 0 ? void 0 : _tableData$anomalies.length) > 0;
  const hasActiveFilter = (_swimLaneSeverity$len = swimLaneSeverity === null || swimLaneSeverity === void 0 ? void 0 : swimLaneSeverity.length) !== null && _swimLaneSeverity$len !== void 0 ? _swimLaneSeverity$len : false;
  (0, _react.useEffect)(() => {
    if (!noJobsSelected) {
      (0, _explorer_utils.getDataViewsAndIndicesWithGeoFields)(selectedJobs, dataViewsService, mlIndexUtils).then(({
        sourceIndicesWithGeoFieldsMap,
        dataViews: dv
      }) => {
        setSourceIndicesWithGeoFields(sourceIndicesWithGeoFieldsMap);
        setDataViews(dv);
      }).catch(console.error); // eslint-disable-line no-console
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(selectedJobIds)]);
  if (noJobsSelected && !loading) {
    return /*#__PURE__*/_react.default.createElement(ExplorerPage, {
      dataViews: dataViews,
      jobSelectorProps: jobSelectorProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_components.ExplorerNoJobsSelected, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 475,
        columnNumber: 9
      }
    }));
  }
  if (!hasResultsWithAnomalies && !isDataLoading && !hasActiveFilter) {
    return /*#__PURE__*/_react.default.createElement(ExplorerPage, {
      dataViews: dataViews,
      jobSelectorProps: jobSelectorProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 482,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_components.ExplorerNoResultsFound, {
      hasResults: hasResults,
      selectedJobsRunning: selectedJobsRunning,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 483,
        columnNumber: 9
      }
    }));
  }
  const bounds = timefilter.getActiveBounds();
  const mainPanelContent = /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 491,
      columnNumber: 5
    }
  }, stoppedPartitions && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: 's',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.stoppedPartitionsExistCallout",
      defaultMessage: "There may be fewer results than there could have been because stop_on_warn is turned on. Both categorization and subsequent anomaly detection have stopped for some partitions in {jobsWithStoppedPartitions, plural, one {job} other {jobs}} [{stoppedPartitions}] where the categorization status has changed to warn.",
      values: {
        jobsWithStoppedPartitions: stoppedPartitions.length,
        stoppedPartitions: stoppedPartitions.join(', ')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 496,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 493,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_anomaly_timeline.AnomalyTimeline, {
    explorerState: explorerState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 510,
      columnNumber: 7
    }
  }), alertsData.length > 0 ? /*#__PURE__*/_react.default.createElement(_alerts.AlertsPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 512,
      columnNumber: 32
    }
  }) : null, annotationsError !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "mlAnomalyExplorerAnnotationsPanel error",
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 517,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.annotationsErrorTitle",
    defaultMessage: "Annotations",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 518,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 524,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.explorer.annotationsErrorCallOutTitle', {
      defaultMessage: 'An error occurred loading annotations:'
    }),
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 532,
      columnNumber: 15
    }
  }, annotationsError))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 535,
      columnNumber: 11
    }
  })), loading === false && tableData && (_tableData$anomalies2 = tableData.anomalies) !== null && _tableData$anomalies2 !== void 0 && _tableData$anomalies2.length ? /*#__PURE__*/_react.default.createElement(AnomaliesMap, {
    anomalies: tableData.anomalies,
    jobIds: selectedJobIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 539,
      columnNumber: 9
    }
  }) : null, annotationsCnt > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "mlAnomalyExplorerAnnotationsPanel loaded",
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 543,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: htmlIdGen(),
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "mlAnomalyExplorerAnnotationsPanelButton",
      size: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 551,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 552,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.annotationsTitle",
      defaultMessage: "Annotations {badge}",
      values: {
        badge
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 553,
        columnNumber: 21
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 565,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_annotations_table.AnnotationsTable
  // @ts-ignore inferred js types are incorrect
  , {
    annotations: annotationsData,
    drillDown: true,
    numberBadge: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 566,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(AnnotationFlyout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 575,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 576,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 581,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 582,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 583,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 584,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.anomaliesTitle",
    defaultMessage: "Anomalies",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 585,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginLeft: 'auto',
      alignSelf: 'baseline'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_context_menu.AnomalyContextMenu, {
    selectedJobs: selectedJobs,
    mergedGroupsAndJobsIds: mergedGroupsAndJobsIds,
    selectedCells: selectedCells,
    bounds: bounds,
    interval: swimLaneBucketInterval ? swimLaneBucketInterval.asSeconds() : undefined,
    chartsCount: chartsData.seriesToPlot.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 594,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 605,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    responsive: true,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 607,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 608,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_select_severity.SelectSeverity, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 609,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 611,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_select_interval.SelectInterval, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 612,
      columnNumber: 13
    }
  })), chartsData.seriesToPlot.length > 0 && selectedCells !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 615,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_checkbox_showcharts.CheckboxShowCharts, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 621,
      columnNumber: 9
    }
  }), showCharts ?
  /*#__PURE__*/
  // @ts-ignore inferred js types are incorrect
  _react.default.createElement(ExplorerChartsContainer, (0, _extends2.default)({}, chartsData, {
    severity,
    tableData,
    timefilter,
    mlLocator,
    timeBuckets,
    onSelectEntity: applyFilter,
    chartsService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 625,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 639,
      columnNumber: 9
    }
  }), tableError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.ml.explorer.anomaliesTableErrorTitle', {
      defaultMessage: 'An error occurred loading anomalies table data'
    }),
    "data-test-subj": "mlAnomaliesTableErrorCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 642,
      columnNumber: 11
    }
  }, tableError) : tableData ? /*#__PURE__*/_react.default.createElement(_anomalies_table.AnomaliesTable, {
    bounds: bounds,
    tableData: tableData,
    influencerFilter: applyFilter,
    sourceIndicesWithGeoFields: sourceIndicesWithGeoFields,
    selectedJobs: selectedJobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 653,
      columnNumber: 11
    }
  }) : null));
  return /*#__PURE__*/_react.default.createElement(ExplorerPage, {
    dataViews: dataViews,
    jobSelectorProps: jobSelectorProps,
    filterActive: filterActive,
    filterPlaceHolder: filterPlaceHolder,
    indexPattern: indexPattern,
    queryString: queryString,
    updateLanguage: updateLanguage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 666,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 675,
      columnNumber: 7
    }
  }), noInfluencersConfigured ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 678,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 679,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.ml.explorer.noConfiguredInfluencersTooltip', {
      defaultMessage: 'The Top Influencers list is hidden because no influencers have been configured for the selected jobs.'
    }),
    position: "right",
    type: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 680,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 689,
      columnNumber: 11
    }
  }, mainPanelContent)) : /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 692,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    direction: isMobile ? 'vertical' : 'horizontal',
    onPanelWidthChange: onPanelWidthChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 693,
      columnNumber: 11
    }
  }, (EuiResizablePanel, EuiResizableButton, actions) => {
    collapseFn.current = () => actions.togglePanel('topInfluencers', {
      direction: 'left'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      panelRef: topInfluencersPanelRef,
      id: 'topInfluencers',
      mode: ['collapsible', {
        'data-test-subj': 'mlTopInfluencersToggle',
        position: 'top'
      }],
      minSize: '200px',
      initialSize: 20,
      paddingSize: 'none',
      onToggleCollapsed: onToggleCollapsed,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 703,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlAnomalyExplorerInfluencerList",
      css: (0, _react2.css)`
                        padding: calc(${euiTheme.size.base} + ${euiTheme.border.width.thin})
                          ${euiTheme.size.l} ${euiTheme.size.l} 0;
                      `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 718,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      responsive: false,
      alignItems: "baseline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 725,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 731,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 732,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 733,
        columnNumber: 29
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.topInfuencersTitle",
      defaultMessage: "Top influencers",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 734,
        columnNumber: 31
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 741,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopover, {
      anchorPosition: "upCenter",
      title: _i18n.i18n.translate('xpack.ml.explorer.topInfluencersPopoverTitle', {
        defaultMessage: 'Top influencers'
      }),
      buttonCss: (0, _react2.css)`
                              color: inherit;
                            `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 742,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 751,
        columnNumber: 29
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.topInfluencersTooltip",
      defaultMessage: "View the relative impact of the top influencers in the selected time period and add them as filters on the results. Each influencer has a maximum anomaly score between 0-100 and a total anomaly score for that period.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 752,
        columnNumber: 31
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'm',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 761,
        columnNumber: 23
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10,
      isLoading: influencersLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 763,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_influencers_list.InfluencersList, {
      influencers: influencers,
      influencerFilter: applyFilter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 764,
        columnNumber: 25
      }
    })))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 769,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: "mainPage",
      mode: "main",
      minSize: '70%',
      initialSize: 80,
      paddingSize: 'none',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 771,
        columnNumber: 19
      }
    }, mainPanelContent));
  })));
};
exports.Explorer = Explorer;