"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrainedAnalysisTitle = exports.AnalyticsEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _data_frame_analytics_kibana = _interopRequireDefault(require("./data_frame_analytics_kibana.png"));
var _ml_nodes_check = require("../../../../../ml_nodes_check");
var _kibana = require("../../../../../contexts/kibana");
var _locator = require("../../../../../../../common/constants/locator");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
var _ml_empty_prompt_card = require("../../../../../components/overview/ml_empty_prompt_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/empty_prompt/empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TrainedAnalysisTitle = () => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.dataFrame.analyticsList.emptyPromptTitle",
  defaultMessage: "Trained analysis of your data",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 7
  }
})));
exports.TrainedAnalysisTitle = TrainedAnalysisTitle;
const AnalyticsEmptyPrompt = ({
  showDocsLink = false
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const mlLocator = (0, _kibana.useMlManagementLocator)();
  const [canCreateDataFrameAnalytics, canStartStopDataFrameAnalytics] = (0, _check_capabilities.usePermissionCheck)(['canCreateDataFrameAnalytics', 'canStartStopDataFrameAnalytics']);
  const disabled = !(0, _ml_nodes_check.mlNodesAvailable)() || !canCreateDataFrameAnalytics || !canStartStopDataFrameAnalytics;
  const navigateToSourceSelection = async () => {
    if (!mlLocator) return;
    await mlLocator.navigate({
      sectionId: 'ml',
      appId: `analytics/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_SOURCE_SELECTION}`
    });
  };
  return /*#__PURE__*/_react.default.createElement(_ml_empty_prompt_card.MLEmptyPromptCard, {
    iconSrc: _data_frame_analytics_kibana.default,
    iconAlt: _i18n.i18n.translate('xpack.ml.dataFrame.analyticsList.emptyPromptTitle', {
      defaultMessage: 'Trained analysis of your data'
    }),
    title: _i18n.i18n.translate('xpack.ml.dataFrame.analyticsList.emptyPromptTitle', {
      defaultMessage: 'Trained analysis of your data'
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.analyticsList.emptyPromptText",
      defaultMessage: "Train outlier detection, regression, or classification machine learning models using data frame analytics.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }),
    actions: [...[/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: navigateToSourceSelection,
      isDisabled: disabled,
      fill: true,
      color: "primary",
      "data-test-subj": "mlAnalyticsCreateFirstButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataFrame.analyticsList.emptyPromptButtonText",
      defaultMessage: "Create Data Frame Analytics job",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }))], ...(showDocsLink ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      target: "_blank",
      href: docLinks.links.ml.dataFrameAnalytics,
      "data-test-subj": "mlAnalyticsReadDocumentationButton",
      iconType: "popout",
      iconSide: "left",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.common.readDocumentationLink",
      defaultMessage: "Read documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    }))] : [])],
    "data-test-subj": "mlNoDataFrameAnalyticsFound",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
};
exports.AnalyticsEmptyPrompt = AnalyticsEmptyPrompt;