"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdBadges = IdBadges;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _group_selector_menu = require("../group_or_job_selector_menu/group_selector_menu");
var _job_selector_button = require("../group_or_job_selector_menu/job_selector_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_selector/id_badges/id_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function IdBadges({
  limit,
  selectedGroups,
  onLinkClick,
  selectedJobIds,
  showAllBarBadges,
  page,
  onRemoveJobId,
  selectedJobs
}) {
  const badges = [];
  const singleMetricViewerDisabledIds = (0, _react.useMemo)(() => selectedJobs.filter(job => !job.isSingleMetricViewerJob).map(job => job.id), [selectedJobs]);
  // Create group badges. Skip job ids here.
  for (let i = 0; i < selectedGroups.length; i++) {
    const currentGroup = selectedGroups[i];
    badges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: currentGroup.groupId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_group_selector_menu.GroupSelectorMenu, {
      groupId: currentGroup.groupId,
      jobIds: currentGroup.jobIds,
      page: page,
      onRemoveJobId: onRemoveJobId,
      removeJobIdDisabled: selectedJobIds.length < 2,
      removeGroupDisabled: selectedGroups.length < 2 && selectedJobIds.length <= currentGroup.jobIds.length,
      singleMetricViewerDisabledIds: singleMetricViewerDisabledIds,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    })));
  }
  // Create badges for jobs with no groups
  for (let i = 0; i < selectedJobIds.length; i++) {
    const currentId = selectedJobIds[i];
    if (selectedGroups.some(g => g.jobIds.includes(currentId))) {
      continue;
    }
    badges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: currentId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_job_selector_button.AnomalyDetectionInfoButton, {
      jobId: currentId,
      page: page,
      onRemoveJobId: onRemoveJobId,
      removeJobIdDisabled: selectedJobIds.length < 2,
      isSingleMetricViewerDisabled: singleMetricViewerDisabledIds.includes(currentId),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    })));
  }
  if (showAllBarBadges || badges.length <= limit) {
    if (badges.length > limit) {
      badges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        key: "more-badges-bar-link",
        onClick: onLinkClick,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        grow: false,
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.ml.jobSelector.hideBarBadges', {
        defaultMessage: 'Hide'
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badges);
  } else {
    const overFlow = badges.length - limit;
    badges.splice(limit);
    badges.push(/*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: "more-badges-bar-link",
      onClick: onLinkClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.ml.jobSelector.showBarBadges', {
      defaultMessage: `And {overFlow} more`,
      values: {
        overFlow
      }
    }))));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badges);
  }
}