"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeaderItems = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/collapsible_panel/panel_header_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PanelHeaderItems = ({
  headerItems,
  compressed = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: compressed ? 's' : 'l',
    alignItems: 'center',
    wrap: true,
    justifyContent: 'flexEnd',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, headerItems.map((item, i) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: i,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: i < (headerItems === null || headerItems === void 0 ? void 0 : headerItems.length) - 1 ? {
        borderRight: euiTheme.border.thin,
        paddingRight: compressed ? euiTheme.size.s : euiTheme.size.l
      } : null,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 13
      }
    }, item));
  }));
};
exports.PanelHeaderItems = PanelHeaderItems;